#ifndef GAME_H
#define GAME_H

#include <kmenubar.h>
#include <qpopupmenu.h>
#include <qlcdnumber.h>

#include <qlist.h>
#include <qfileinfo.h>

#include <kmainwindow.h>

#include "rattler.h"
#include "trys.h"
#include "score.h"
#include "progress.h"
#include "levels.h"

class KAction;
class KSelectAction;
class KRadioAction;

class Game : public KMainWindow
  {
    Q_OBJECT
public:
    Game();
    ~Game() {}
private slots:
    void ballsChecked();
    void skillChecked();
    void snakesChecked();
    void pixChecked();

    void newGame();
    void pauseGame();
    void togglePaused();
    void quitGame();

    void backgroundColor();
    void confKeys();

    void showHighScores();
    void startingRoom();

private:

    Rattler *rattler;
    QLCDNumber *lcd;

    Trys *trys;
    Score   *score;
    Progress *pg;
    Levels *levels;

    KConfig *conf;

    void menu();
    void checkMenuItems();
    void lookupBackgroundPixmaps();

    KAction *pause;
    KSelectAction *balls;
    KSelectAction *snakes;
    KRadioAction *skills[4];
    KSelectAction *pix;

    QStringList backgroundPixmaps;
};

#endif // GAME_H
