#ifndef KPSWIDGET_H
#define KPSWIDGET_H

#include <kprocess.h>

#include <qfiledialog.h>
#include <stdlib.h>
#include <math.h>
#include <qapplication.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qpaintdevice.h>
#include <qscrollbar.h>
#include <qbitmap.h>
#include <qsocketnotifier.h>
#define	 GC GC_QQQ				// avoid type mismatch
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <ctype.h>

#include "messages.h"
class InterpreterDialog;

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#ifndef None
#define None -1
#endif

#ifndef XlibSpecificationRelease
typedef char *XPointer;
#endif

#ifndef SEEK_SET
#define SEEK_SET 0
#endif

#ifndef XlibSpecificationRelease
typedef char *XPointer;
#endif

#include <errno.h>
/* BSD 4.3 errno.h does not declare errno */
extern int errno;
/* Both error returns are checked for non-blocking I/O. */
/* Manufacture the other error code if only one exists. */
#if !defined(EWOULDBLOCK) && defined(EAGAIN)
#define EWOULDBLOCK EAGAIN
#endif
#if !defined(EAGAIN) && defined(EWOULDBLOCK)
#define EAGAIN EWOULDBLOCK
#endif

struct record_list {
    FILE *fp;
    long begin;
    unsigned int len;
    bool seek_needed;
    bool close;
    struct record_list *next;
};

class KFVWidget : public QWidget
{
  Q_OBJECT;

 public:
  KFVWidget (QWidget *parent);

  Window mwin;
  Atom gs_colors, ghostview, gs_next, gs_page, gs_done;

 signals:
  void moveOffset (int x, int y);

 protected:
  int dragstartx, dragstarty;
  int draglastx, draglasty;
  int startoffx, startoffy;

  void mousePressEvent (QMouseEvent *);
  void mouseMoveEvent (QMouseEvent *);
  bool x11Event(XEvent *ev);
};


class KPSWidget : public QWidget
{
    Q_OBJECT

public:
	KPSWidget(QWidget *parent);
	~KPSWidget();


	QScrollBar *hScrollBar() {return vertScrollBar;}
	QScrollBar *vScrollBar() {return horScrollBar;}
	
	Display 	*gs_display;
	Window 		gs_window;
	bool 		busy;
	Pixmap background_pixmap;
	
	
	bool sendPS(FILE *fp, long begin,unsigned int len,bool close);
	void layout();
	void setDocumentPresent( bool state );
	void disableInterpreter();
	void enableInterpreter();
	bool isInterpreterReady();
	bool isInterpreterRunning();
	bool nextPage();

	/**
	 * Emit size/pos message to sync up the scroll box.
	 *  (Doesn't seem to help much.)
	 **/
	//	void sync(); 
	
	KFVWidget *fullView;
	QScrollBar *vertScrollBar;
	QScrollBar *horScrollBar;
	QWidget *patch;
	QFrame *pageFrame;
	QFrame *topFrame;
	QFrame *leftFrame;
	QFrame *rightFrame;
	QFrame *bottomFrame;

	
	void scrollLeft();
	void scrollRight();
	void scrollUp();
	void scrollDown();
	void scrollTop();
	bool readDown();
	
	void movePage();
	bool configure();
	void writeSettings();
	
	int orient_angle;
	int orientation;
	bool	antialias;
	bool show_messages;
	bool	changed;
	bool disable_start;
	QString filename;
	int llx, lly, urx, ury;
	int left_margin, right_margin, bottom_margin, top_margin;
	int foreground, background_pixel;
	float xdpi, ydpi;
	int  scroll_x_offset, scroll_y_offset;
		
public slots:
	void gs_input();
	void gs_output(KProcess *, char *buffer, int len);
	void slotVertScroll( int value );
	void slotHorScroll( int value );
	void slotScroll( QPoint point );

protected slots:
	void interpreterFailed();

protected:
	void resizeEvent(QResizeEvent *);
	void paintEvent(QPaintEvent *);
	void wheelEvent(QWheelEvent *);

	void setup();
	void startInterpreter();
	void stopInterpreter();
	bool computeSize();

signals:
        void pageSizeChanged( QSize size );
	void viewSizeChanged( QSize size );
	void currentPosChanged( QPoint point );
	
private:
	MessagesDialog *messages;
	InterpreterDialog *intConfig;

        KProcess *proc;

	bool mDocumentPresent;
	int  clip_x, clip_y, clip_width, clip_height;
	
	struct record_list *ps_input;	
	char *input_buffer;	
	unsigned int bytes_left;
	bool stdin_ready;
	bool interpreter_ready;	
}; 

#endif // KPSWIDGET_H


