#include "mainwidget.h"
#include "bitmapwidget.h"
#include <qscrollview.h>
#include <klocale.h>

KPMainWidget::KPMainWidget(QWidget *parent, const char *name)
    : QSplitter(Horizontal, parent, name)
{

    bmpList = new KPBitmapList(i18n("bmap_"), this);
    QScrollView *bmpView = new QScrollView(this);
    bmpWidget = new KPBitmapWidget(bmpView->viewport());
    bmpView->addChild(bmpWidget);
    setResizeMode(bmpList, QSplitter::KeepSize);

    bmpList->setBitmapWidget(bmpWidget);

    connect(this, SIGNAL(message(const QString &)), parent,
            SLOT(slotMessage(const QString &)));
    connect(bmpList, SIGNAL(message(const QString &)), parent,
            SLOT(slotMessage(const QString &)));
    connect(bmpList, SIGNAL(setProgress(int)), parent,
            SLOT(slotProgress(int)));
    connect(bmpList, SIGNAL(saveEnabled(bool)), parent,
            SLOT(slotSaveEnabled(bool)));
    connect(bmpList, SIGNAL(closeEnabled(bool)), parent,
            SLOT(slotCloseEnabled(bool)));

    connect(bmpWidget, SIGNAL(scaleChanged(const QString &)), parent,
            SLOT(slotZoom(const QString &)));
    connect(bmpWidget, SIGNAL(zoomInEnabled(bool)), parent,
            SLOT(slotZoomInEnabled(bool)));
    connect(bmpWidget, SIGNAL(zoomOutEnabled(bool)), parent,
            SLOT(slotZoomOutEnabled(bool)));

}

void KPMainWidget::slotLoad()
{
    bmpList->load();
}

void KPMainWidget::slotReset()
{
    bmpList->reset();
}

void KPMainWidget::slotSaveCurrentBitmap()
{
    bmpList->saveCurrentBitmap();
}

void KPMainWidget::slotSaveAllBitmaps()
{
    bmpList->saveAll();
}

void KPMainWidget::slotSaveCHeader()
{
    bmpList->saveCHeader();
}

void KPMainWidget::slotIncreaseScale()
{
    bmpWidget->increaseScale();
}

void KPMainWidget::slotDecreaseScale()
{
    bmpWidget->decreaseScale();
}

void KPMainWidget::slotSavePointArray()
{
    bmpList->savePointArray();
}

void KPMainWidget::load(const QString &s)
{
    bmpList->loadFile(s);
}


#include "mainwidget.moc"


