/*
* numdlg.cpp -- Implementation of class KNumDialog.
* Author:	Sirtaj Singh Kang
* Version:	$Id: numdlg.cpp,v 1.5 2000/08/06 10:25:11 bieker Exp $
* Generated:	Fri Oct  9 01:51:29 EST 1998
*/

#include <stdlib.h>

#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlabel.h>

#include <klocale.h>
#include <kglobal.h>

#include "typolayout.h"
#include "numdlg.h"

KNumDialog::KNumDialog( QWidget *parent )
	: QDialog( parent, "", true )
{
	KTypoLayout *layout = new KTypoLayout( this );
	layout->setGridSize( 2, 3 );
	layout->setHSpace( 2, 2 );
	layout->setVSpace( 2, 2 );
	
	_message = layout->newLabel( i18n("Enter a value:"), 
			0, 0, 2, 1 );
	_edit = layout->newLineEdit( "", 0, 1, 2, 1 );
	connect( _edit, SIGNAL(returnPressed()), this, SLOT(accept()));
	_edit->setFocus();
	
	QPushButton *ok = layout->newButton( i18n("OK"), 0, 2, 1, 1 );
	connect( ok, SIGNAL(clicked()), SLOT(accept()) );
	KBagConstraints *c = layout->constraints( ok );
	c->setXSpace( 2 );
	c->setYSpace( 4 );

	QPushButton *canc = layout->newButton( i18n("Cancel"), 1, 2, 1, 1 );
	c = layout->constraints( canc );
	c->setXSpace( 2 );
	c->setYSpace( 4 );
	connect( canc, SIGNAL(clicked()), SLOT(reject()) );

	resize( 200, 120 );
}

KNumDialog::~KNumDialog()
{
}

bool KNumDialog::getNum( int& num, const QString & message )
{
	_message->setText( message );
	_edit->setText( KGlobal::locale()->formatNumber( num, 0 ) );

	if ( exec() ) {
		num = (int)KGlobal::locale()->readNumber( _edit->text() );
		return true;
	}

	return false;
}

bool KNumDialog::getNum( double& num, const QString & message )
{
	_message->setText( message );
	_edit->setText( KGlobal::locale()->formatNumber( num ) );

	if ( exec() ) {
		num = KGlobal::locale()->readNumber( _edit->text() );
		return true;
	}

	return false;
}

