/*
 *   kghostview: KDE PostScript viewer
 *   This file: Copyright (C) 2000 Espen Sand, espen@kde.org
 *   Uses ideas from ealier dialog code by Mark Donohoe and Tim Theisen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef _INTERPRETER_DIALOG_H_
#define _INTERPRETER_DIALOG_H_

class QCheckBox;
class QLineEdit;
class QRadioButton;

#include <kdialogbase.h>

class InterpreterDialog : public KDialogBase 
{
  Q_OBJECT

  public:
    enum {COLOR_PALETTE, GRAY_PALETTE, MONO_PALETTE};
    enum {PIX_BACKING, STORE_BACKING};

    InterpreterDialog( QWidget *parent=0, const char* name=0, bool modal=true);
    void setup();

    void readSettings();
    void writeSettings();

    bool antiAlias();
    bool showMessages();
    bool platformFonts();
    int  paletteType();
    int  backingStoreType();

  protected slots:
    virtual void slotOk();
    virtual void slotDefault();
    void slotAaToggled(bool);
    void slotPaletteChange(bool);

  private:
    QLineEdit *mInterpreterEdit;
    QCheckBox *mAntiAliasCheck;
    QCheckBox *mPlatformFontCheck;
    QCheckBox *mMessagesCheck;
    QRadioButton *mMonoRadio;
    QRadioButton *mGrayscaleRadio;
    QRadioButton *mColorRadio;
    QRadioButton *mPixmapRadio;
    QRadioButton *mBackingStoreRadio;

    bool mAntialias;
    bool mShowMessages;
    bool mPlatformFonts;
    int  mPaletteType;
    int  mBackingType;
};

#endif 

