/*
* khelpidx.cpp -- Implementation of class KHelpIndex.
* Author:	Sirtaj Singh Kang
* Version:	$Id: khelpidx.cpp,v 1.8 2000/08/06 10:25:11 bieker Exp $
* Generated:	Thu Sep  3 13:16:48 EST 1998
*/

#include <assert.h>
#include <qfileinfo.h>
#include <qregexp.h>

#include <kprocess.h>
#include <kapp.h>
#include <klocale.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <kdebug.h>

#include "khelpidx.h"

KHelpIndex::KHelpIndex( const QString & path ) 
	:_valid	( false ), 
	_index	( 0 ), 
	_path	( new QString ),
	_basename( new QString )
{ 
	assert( path != 0 );
	assert( kapp != 0 );

	*_path = locate("html", KGlobal::locale()->language() + '/' + path);

	if (_path->isNull()) {

		*_path = locate("html", "default/" + path);

		if( !_path->isNull() )
			_valid = true;
	}
	else {
		_valid = true;
	}

	if( _valid )
		readIndex( *_path );
}

KHelpIndex::~KHelpIndex() 
{
	delete _index;
	delete _path;
	delete _basename;
}

bool KHelpIndex::readIndex( const QString & path )
{
	assert( !path.isNull() );
	
	if ( _index == 0 ) {
		// create index object

		_index = new QDict<QString>;

		if ( _index == 0 ) {
			kdWarning() << "KHelpIndex::readIndex: Out of memory" << endl;
			return false;
		}

		_index->setAutoDelete( true );
	}

	// read the index file
	QFile file( path );

	if( !file.exists() || !file.open( IO_ReadOnly ) ) {
		kdWarning() << "KHelpIndex::readIndex: Can't read "
			<< path << endl;
		return false;
	}

	char buffer[ 1001 ];
	QRegExp reg( "\\s*==\\s*" );
	int len = 0, pos = 0, linelen = 0;

	while ( (linelen = file.readLine( buffer, 1000 )) > 0 ) {
		pos = reg.match( buffer, 0, &len );

		if ( pos < 0 ) {
			// skip non-conforming lines
			continue;
		}

		buffer[ pos ] = 0;
		buffer[ linelen - 1 ] = 0;

		if( buffer[ pos + len ] == 0 ) {
			continue;
		}

//		debug( "Inserting '%s' at '%s'", buffer + pos + len,
//			buffer );
	
		_index->insert( buffer, 
			new QString( buffer + pos + len ) );
	}

	return true;
}

bool KHelpIndex::invoke( const QString & tag )
{
	if( !valid() ) {
		kdWarning() << "KHelpIndex::invoke: Attempt to invoke"
			" invalid object." << endl;
		return false;
	}

	QString *p = _index->find( tag );

	if( p == 0 ) {
		return false;
	}

	QString s = *p;

	if( s.isEmpty() ) {
		return false;
	}
	
	s.insert( 0, '/' );
	s.insert( 0, *_path );

	KProcess launcher;
	launcher << "kdehelp" << s;
	launcher.start( KProcess::DontCare );

	return true;
}

#ifdef KHELPIDX_TEST
int main( int argc, char **argv )
{
	assert( argc > 1 );

	KApplication app( argc, argv );

	KHelpIndex idx( argv[ 1 ] );

	idx.invoke( "whatis" );
}
#endif
