/* ANSI-C code produced by gperf version 2.7.1 (19981006 egcs) */
/* Command-line: gperf -a -L ANSI-C -C -G -c -o -t -k * -NfindEntity -D -Hhash_Entity -Wwordlist_Entity -s 2 kentities.gperf  */
/*   This file is part of the KDE libraries
  
     Copyright (C) 1999 Lars Knoll (knoll@mpi-hd.mpg.de)
  
     This library is free software; you can redistribute it and/or
     modify it under the terms of the GNU Library General Public
     License as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later version.
  
     This library is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Library General Public License for more details.
  
     You should have received a copy of the GNU Library General Public License
     along with this library; see the file COPYING.LIB.  If not, write to
     the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
  
  ----------------------------------------------------------------------------
  
    khtmlentities.gperf: input file to generate a hash table for entities
    khtmlentities.c: DO NOT EDIT! generated by the command
    "gperf -a -L "ANSI-C" -C -G -c -o -t -k '*' -NfindEntity -D -s 2 khtmlentities.gperf > khtmlentities.c"   
    from khtmlentities.gperf 

    $Id: kentities.c,v 1.6 2000/09/05 09:47:18 knoll Exp $     
*/  
struct entity {
    const char *name;
    int code;
};

#define TOTAL_KEYWORDS 257
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 8
#define MIN_HASH_VALUE 2
#define MAX_HASH_VALUE 1428
/* maximum key range = 1427, duplicates = 1 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
hash_Entity (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,   10,
        20,   15,    0, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429,   95,   10,    5,   35,   20,
      1429,    5,    5,   65, 1429,   10,    0,    0,   15,   60,
         0,    0,    5,    0,    0,   25, 1429, 1429,   20,   45,
         0, 1429, 1429, 1429, 1429, 1429, 1429,    0,   40,   65,
       290,    5,   35,  295,  370,   15,    0,    0,   25,  215,
       453,  335,  335,  145,    0,  125,  110,   10,   20,    5,
         5,   80,   15, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429, 1429,
      1429, 1429, 1429, 1429, 1429, 1429
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 8:
        hval += asso_values[(unsigned char)str[7]];
      case 7:
        hval += asso_values[(unsigned char)str[6]];
      case 6:
        hval += asso_values[(unsigned char)str[5]];
      case 5:
        hval += asso_values[(unsigned char)str[4]];
      case 4:
        hval += asso_values[(unsigned char)str[3]];
      case 3:
        hval += asso_values[(unsigned char)str[2]];
      case 2:
        hval += asso_values[(unsigned char)str[1]];
      case 1:
        hval += asso_values[(unsigned char)str[0]];
        break;
    }
  return hval;
}

static const struct entity wordlist_Entity[] =
  {
    {"LT", 60},
    {"rarr", 0x2192},
    {"GT", 62},
    {"Mu", 0x039c},
    {"Tau", 0x03a4},
    {"uarr", 0x2191},
    {"Pi", 0x03a0},
    {"xi", 0x03be},
    {"zwj", 0x200d},
    {"Nu", 0x039d},
    {"ETH", 0x00d0},
    {"larr", 0x2190},
    {"le", 0x2264},
    {"real", 0x211c},
    {"Xi", 0x039e},
    {"crarr", 0x21b5},
    {"QUOT", 34},
    {"THORN", 0x00de},
    {"AMP", 38},
    {"rArr", 0x21d2},
    {"bull", 0x2022},
    {"brvbar", 0x00a6},
    {"uArr", 0x21d1},
    {"rceil", 0x2309},
    {"frac14", 0x00bc},
    {"eta", 0x03b7},
    {"Zeta", 0x0396},
    {"iexcl", 0x00a1},
    {"frac34", 0x00be},
    {"tau", 0x03c4},
    {"lArr", 0x21d0},
    {"Beta", 0x0392},
    {"Eta", 0x0397},
    {"zeta", 0x03b6},
    {"frac12", 0x00bd},
    {"lt", 60},
    {"lceil", 0x2308},
    {"Psi", 0x03a8},
    {"circ", 0x02c6},
    {"acirc", 0x00e2},
    {"ecirc", 0x00ea},
    {"beta", 0x03b2},
    {"ucirc", 0x00fb},
    {"icirc", 0x00ee},
    {"Ecirc", 0x00ca},
    {"Ucirc", 0x00db},
    {"sub", 0x2282},
    {"Delta", 0x0394},
    {"sube", 0x2286},
    {"frasl", 0x2044},
    {"acute", 0x00b4},
    {"aacute", 0x00e1},
    {"equiv", 0x2261},
    {"eacute", 0x00e9},
    {"uacute", 0x00fa},
    {"Ocirc", 0x00d4},
    {"iacute", 0x00ed},
    {"Icirc", 0x00ce},
    {"Eacute", 0x00c9},
    {"Uacute", 0x00da},
    {"mu", 0x03bc},
    {"Prime", 0x2033},
    {"Yacute", 0x00dd},
    {"lrm", 0x200e},
    {"rlm", 0x200f},
    {"Acirc", 0x00c2},
    {"uml", 0x00a8},
    {"auml", 0x00e4},
    {"Oacute", 0x00d3},
    {"euml", 0x00eb},
    {"Iacute", 0x00cd},
    {"uuml", 0x00fc},
    {"exist", 0x2203},
    {"iuml", 0x00ef},
    {"clubs", 0x2663},
    {"Euml", 0x00cb},
    {"yacute", 0x00fd},
    {"Uuml", 0x00dc},
    {"macr", 0x00af},
    {"Aacute", 0x00c1},
    {"darr", 0x2193},
    {"Yuml", 0x0178},
    {"ge", 0x2265},
    {"reg", 0x00ae},
    {"sect", 0x00a7},
    {"Ouml", 0x00d6},
    {"Iuml", 0x00cf},
    {"agrave", 0x00e0},
    {"egrave", 0x00e8},
    {"yuml", 0x00ff},
    {"ugrave", 0x00f9},
    {"or", 0x22a6},
    {"para", 0x00b6},
    {"igrave", 0x00ec},
    {"aelig", 0x00e6},
    {"Egrave", 0x00c8},
    {"Auml", 0x00c4},
    {"Ugrave", 0x00d9},
    {"pi", 0x03c0},
    {"sum", 0x2211},
    {"euro", 0x20ac},
    {"sim", 0x223c},
    {"weierp", 0x2118},
    {"piv", 0x03d6},
    {"harr", 0x2194},
    {"radic", 0x221a},
    {"loz", 0x25ca},
    {"Ograve", 0x00d2},
    {"Phi", 0x03a6},
    {"dArr", 0x21d3},
    {"Igrave", 0x00cc},
    {"Chi", 0x03a7},
    {"cap", 0x2229},
    {"cedil", 0x00b8},
    {"gt", 62},
    {"trade", 0x2122},
    {"Ccedil", 0x00c7},
    {"cup", 0x222a},
    {"iquest", 0x00bf},
    {"OElig", 0x0152},
    {"Agrave", 0x00c0},
    {"forall", 0x2200},
    {"delta", 0x03b4},
    {"Gamma", 0x0393},
    {"part", 0x2202},
    {"tilde", 0x02dc},
    {"atilde", 0x00e3},
    {"chi", 0x03c7},
    {"AElig", 0x00c6},
    {"ne", 0x2260},
    {"iota", 0x03b9},
    {"nu", 0x03bd},
    {"Ntilde", 0x00d1},
    {"hArr", 0x21d4},
    {"ni", 0x220b},
    {"ccedil", 0x00e7},
    {"sup", 0x2283},
    {"times", 0x00d7},
    {"zwnj", 0x200c},
    {"psi", 0x03c8},
    {"supe", 0x2287},
    {"szlig", 0x00df},
    {"sup1", 0x00b9},
    {"ocirc", 0x00f4},
    {"eth", 0x00f0},
    {"sup3", 0x00b3},
    {"Theta", 0x0398},
    {"alefsym", 0x2135},
    {"sup2", 0x00b2},
    {"raquo", 0x00bb},
    {"there4", 0x2234},
    {"Otilde", 0x00d5},
    {"Iota", 0x0399},
    {"laquo", 0x00ab},
    {"nabla", 0x2207},
    {"Sigma", 0x03a3},
    {"oacute", 0x00f3},
    {"image", 0x2111},
    {"curren", 0x00a4},
    {"yen", 0x00a5},
    {"Atilde", 0x00c3},
    {"Lambda", 0x039b},
    {"amp", 38},
    {"prime", 0x2032},
    {"lambda", 0x03bb},
    {"shy", 0x00ad},
    {"Omega", 0x03a9},
    {"int", 0x222b},
    {"ouml", 0x00f6},
    {"deg", 0x00b0},
    {"theta", 0x03b8},
    {"permil", 0x2030},
    {"quot", 34},
    {"lowast", 0x2217},
    {"isin", 0x2208},
    {"hearts", 0x2665},
    {"rsquo", 0x2019},
    {"rsaquo", 0x203a},
    {"nsub", 0x2284},
    {"micro", 0x00b5},
    {"Dagger", 0x2021},
    {"cent", 0x00a2},
    {"divide", 0x00f7},
    {"lsquo", 0x2018},
    {"lsaquo", 0x2039},
    {"diams", 0x2666},
    {"sigma", 0x03c3},
    {"sbquo", 0x201a},
    {"ograve", 0x00f2},
    {"ordf", 0x00aa},
    {"kappa", 0x03ba},
    {"perp", 0x22a5},
    {"oelig", 0x0153},
    {"emsp", 0x2003},
    {"Kappa", 0x039a},
    {"sigmaf", 0x03c2},
    {"rho", 0x03c1},
    {"Oslash", 0x00d8},
    {"Rho", 0x03a1},
    {"phi", 0x03c6},
    {"gamma", 0x03b3},
    {"alpha", 0x03b1},
    {"rfloor", 0x230b},
    {"and", 0x22a5},
    {"empty", 0x2205},
    {"ang", 0x2220},
    {"rang", 0x232a},
    {"asymp", 0x2248},
    {"lfloor", 0x230a},
    {"aring", 0x00e5},
    {"lang", 0x2329},
    {"hellip", 0x2026},
    {"rdquo", 0x201d},
    {"otilde", 0x00f5},
    {"ldquo", 0x201c},
    {"otimes", 0x2297},
    {"copy", 0x00a9},
    {"minus", 0x2212},
    {"bdquo", 0x201e},
    {"Alpha", 0x0391},
    {"oplus", 0x2295},
    {"oline", 0x203e},
    {"ordm", 0x00ba},
    {"omega", 0x03c9},
    {"Scaron", 0x0160},
    {"upsih", 0x03d2},
    {"fnof", 0x0192},
    {"Aring", 0x00c5},
    {"sdot", 0x22c5},
    {"spades", 0x2660},
    {"dagger", 0x2020},
    {"not", 0x00ac},
    {"ntilde", 0x00f1},
    {"ensp", 0x2002},
    {"nbsp", 0x00a0},
    {"prod", 0x220f},
    {"percnt", 0x0025},
    {"infin", 0x221e},
    {"scaron", 0x0161},
    {"oslash", 0x00f8},
    {"mdash", 0x2014},
    {"prop", 0x221d},
    {"thetasym", 0x03d1},
    {"Omicron", 0x039f},
    {"cong", 0x2245},
    {"plusmn", 0x00b1},
    {"ndash", 0x2013},
    {"middot", 0x00b7},
    {"thorn", 0x00fe},
    {"epsilon", 0x03b5},
    {"upsilon", 0x03c5},
    {"Epsilon", 0x0395},
    {"Upsilon", 0x03a5},
    {"notin", 0x2209},
    {"thinsp", 0x2009},
    {"omicron", 0x03bf},
    {"pound", 0x00a3}
  };

static const short lookup[] =
  {
      -1,   -1,    0,   -1,    1,   -1,   -1,    2,
      -1,   -1,   -1,   -1,    3,    4,    5,   -1,
      -1,    6,   -1,   -1,   -1,   -1,    7,    8,
      -1,   -1,   -1,    9,   10,   11,   -1,   -1,
      12,   -1,   13,   -1,   -1,   14,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   15,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   16,   17,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   18,   19,   -1,   -1,   -1,   -1,
      20,   -1,   21,   -1,   -1,   22,   -1,   -1,
      -1,   -1,   -1,   23,   24,   -1,   25,   26,
      27,   28,   -1,   29,   30,   -1,   -1,   -1,
      -1,   31,   -1,   -1,   -1,   32,   33,   -1,
      34,   35,   -1,   -1,   36,   -1,   -1,   37,
      -1,   -1,   -1,   -1,   -1,   38,   39,   -1,
      -1,   -1,   -1,   40,   -1,   -1,   -1,   41,
      42,   -1,   -1,   -1,   -1,   43,   -1,   -1,
      -1,   -1,   44,   -1,   -1,   -1,   -1,   45,
      -1,   -1,   46,   -1,   47,   -1,   -1,   -1,
      48,   -1,   -1,   -1,   -1,   -1,   49,   -1,
      -1,   -1,   -1,   50,   51,   -1,   -1,   -1,
      52,   53,   -1,   -1,   -1,   -1,   54,   -1,
      -1,   -1,   55,   56,   -1,   -1,   -1,   57,
      58,   -1,   -1,   -1,   -1,   59,   -1,   -1,
      -1,   -1,   -1,   60,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      61,   62,   -1, -504,   -1,   65, -194,   -2,
      -1,   -1,   -1,   -1,   -1,   66,   67,   -1,
      68,   -1,   -1,   69,   -1,   70,   -1,   -1,
      71,   72,   -1,   -1,   -1,   73,   74,   -1,
      -1,   -1,   75,   -1,   76,   -1,   -1,   77,
      -1,   -1,   -1,   -1,   78,   -1,   -1,   -1,
      -1,   -1,   -1,   79,   -1,   -1,   80,   -1,
      -1,   -1,   -1,   81,   -1,   -1,   82,   83,
      -1,   -1,   -1,   -1,   -1,   84,   -1,   -1,
      -1,   -1,   85,   -1,   -1,   -1,   -1,   86,
      -1,   -1,   -1,   -1,   -1,   -1,   87,   -1,
      -1,   -1,   -1,   88,   -1,   -1,   89,   -1,
      90,   91,   -1,   92,   -1,   93,   -1,   -1,
      -1,   94,   95,   -1,   -1,   96,   -1,   97,
      98,   99,  100,   -1,   -1,   -1,  101,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,  102,   -1,  103,  104,  105,
      -1,   -1,  106,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,  107,   -1,  108,  109,   -1,  110,
      -1,  111,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,  112,   -1,  113,   -1,  114,
      -1,   -1,  115,  116,   -1,  117,   -1,   -1,
     118,   -1,   -1,   -1,  119,  120,   -1,   -1,
      -1,   -1,  121,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,  122,   -1,   -1,   -1,   -1,
     123,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,  124,  125,  126,   -1,  127,   -1,  128,
      -1,   -1,   -1,   -1,  129,   -1,   -1,   -1,
     130,  131,  132,   -1,   -1,  133,  134,  135,
      -1,  136,   -1,  137,   -1,  138,  139,  140,
     141,   -1,   -1,   -1,  142,  143,   -1,   -1,
     144,  145,  146,   -1,  147,   -1,  148,  149,
     150,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,  151,
      -1,   -1,  152,   -1,   -1,   -1,   -1,   -1,
     153,   -1,   -1,  154,   -1,   -1,   -1,   -1,
      -1,   -1,  155,  156,   -1,   -1,   -1,  157,
      -1,   -1,   -1,  158,   -1,  159,   -1,   -1,
      -1,   -1,  160,   -1,   -1,   -1,   -1,  161,
      -1,  162,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,  163,
     164,   -1,  165,   -1,  166,  167,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,  168,   -1,   -1,
      -1,  169,   -1,   -1,   -1,   -1,   -1,   -1,
     170,  171,   -1,   -1,  172,   -1,  173,   -1,
      -1,   -1,   -1,   -1,  174,   -1,   -1,   -1,
     175,   -1,   -1,   -1,  176,  177,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
     178,   -1,   -1,  179,  180,  181,   -1,   -1,
      -1,  182,   -1,   -1,   -1,  183,  184,   -1,
      -1,   -1,  185,   -1,   -1,   -1,   -1,  186,
      -1,   -1,   -1,   -1,  187,  188,   -1,   -1,
     189,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,  190,   -1,   -1,   -1,  191,
     192,   -1,   -1,   -1,  193,  194,   -1,   -1,
      -1,   -1,   -1,  195,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,  196,   -1,   -1,  197,
      -1,  198,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,  199,   -1,   -1,   -1,   -1,
      -1,   -1,  200,   -1,   -1,   -1,   -1,  201,
     202,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,  203,   -1,   -1,   -1,  204,  205,
     206,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
     207,  208,   -1,   -1,   -1,   -1,   -1,   -1,
     209,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,  210,   -1,   -1,   -1,  211,   -1,   -1,
      -1,  212,  213,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,  214,  215,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,  216,   -1,   -1,   -1,  217,
      -1,  218,   -1,   -1,   -1,   -1,  219,   -1,
      -1,   -1,   -1,  220,   -1,   -1,  221,   -1,
      -1,   -1,   -1,   -1,  222,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,  223,
      -1,   -1,   -1,  224,  225,   -1,  226,  227,
     228,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,  229,   -1,
      -1,   -1,   -1,  230,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,  231,   -1,   -1,
     232,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,  233,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,  234,   -1,   -1,
      -1,   -1,   -1,   -1,  235,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,  236,   -1,
     237,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
     238,   -1,  239,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,  240,   -1,   -1,
      -1,  241,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,  242,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,  243,   -1,
     244,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,  245,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,  246,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,  247,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,  248,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,  249,   -1,   -1,   -1,
      -1,  250,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,  251,   -1,   -1,   -1,   -1,
     252,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,  253,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,  254,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,  255,   -1,   -1,  256
  };

#ifdef __GNUC__
__inline
#endif
const struct entity *
findEntity (register const char *str, register unsigned int len)
{
  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash_Entity (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register int index = lookup[key];

          if (index >= 0)
            {
              register const char *s = wordlist_Entity[index].name;

              if (*str == *s && !strncmp (str + 1, s + 1, len - 1))
                return &wordlist_Entity[index];
            }
          else if (index < -TOTAL_KEYWORDS)
            {
              register int offset = - 1 - TOTAL_KEYWORDS - index;
              register const struct entity *wordptr = &wordlist_Entity[TOTAL_KEYWORDS + lookup[offset]];
              register const struct entity *wordendptr = wordptr + -lookup[offset + 1];

              while (wordptr < wordendptr)
                {
                  register const char *s = wordptr->name;

                  if (*str == *s && !strncmp (str + 1, s + 1, len - 1))
                    return wordptr;
                  wordptr++;
                }
            }
        }
    }
  return 0;
}

