// -*- C++ -*-
/*
   Copyright (c) 1999-2000 Stefan Schimanski <1Stein@gmx.de>
                           Christian Esken (esken@kde.org)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef KNOTIFY_H
#define KNOTIFY_H

#include <qtimer.h>
#include <kmainwindow.h>
#include <kurl.h>
#include <dcopobject.h>
#include <kdebug.h>
#include <artsflow.h>
#include <soundserver.h>
#include "KaimanStyle.h"
#include "kmedia2.h"


class MediaFile;
class KaimanPrefDlg;


class Kaiman : public KMainWindow
{
Q_OBJECT

public:
    Kaiman( const QString &skin );
    ~Kaiman();

public slots:
    void togglePlaylist();
    void play();
    void pause();
    void stop();
    void next();
    void prev();
    void seek( int sec );
    void clear();

    void toggleLoop();
    void toggleShuffle();

    void setVolume( int vol );
    void volumeUp();
    void volumeDown();

    void addURL( KURL url );

    void execMixer();
    void preferences();
    void toggleSkin();
    bool loadStyle( const QString &style, const QString &desc="skindata" );

    void dropEvent( QDropEvent * );
    void doDropEvent( QDropEvent * );
    void dragEnterEvent( QDragEnterEvent * );

protected slots:
    bool play( const KURL &url );
    bool play( MediaFile *media );
    bool playNext( bool reverse );

    void seekStart( int value );
    void seekDrag( int value );
    void seekStop( int value );

    void applyPref();
    void okPref();

    void updateStatusDisplay();
    void updateArtsDisplay();
    void pollArts();

private:
    bool initArts();

    KaimanStyle *_style;
    class MediaManager *_mediaManager;

    Arts::PlayObject _playObject;
    Arts::PlayObjectFactory _playObjectFactory;
    Arts::StereoVolumeControl _volumeControl;
    Arts::SimpleSoundServer _soundServer;
    int _volumeEffectID;

    QString _mixerCommand;
    QTimer _statusPollTimer;
    QTimer _artsPollTimer;

    int _lastPolledState;
    bool _looping;
    bool _shuffle;
    bool _altSkin;
    int _volume;
    bool _seeking;
    KaimanPrefDlg *_prefDlg;
};


#endif

