/*
   Copyright (c) 2000 Stefan Schimanski <1Stein@gmx.de>
                 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef PLAYLISTWIN_H_INCLUDED
#define PLAYLISTWIN_H_INCLUDED

#include <kfileitem.h>
#include <klistview.h>
#include <kfileitem.h>
#include <qqueue.h>
#include "playlist.h"
#include "id3.h"


class MediaFileItem;
class MediaSetItem;
class MediaViewItem;
class KDirLister;


class MediaFileItem : public QListViewItem, public MediaFile
{
 public:
    MediaFileItem( QListView *parent )
	: QListViewItem( parent ) { _highlighted = false; };
    MediaFileItem( QListViewItem *parent )
	: QListViewItem( parent ) { _highlighted = false; };
    MediaFileItem( QListViewItem *parent, QListViewItem *after ) 
	: QListViewItem( parent, after ) { _highlighted = false; };
    MediaFileItem( QListView *parent, QListViewItem *after ) 
	: QListViewItem( parent, after ) { _highlighted = false; };

    virtual QString text( int col ) const;
    void highlight( bool on ) { _highlighted = on; };

    void paintCell ( QPainter *, const QColorGroup & cg, int column, int width, int alignment );

 private:
    bool _highlighted;
};


class MediaListView : public KListView
{
 Q_OBJECT
 public:
    MediaListView(QWidget *parent = 0, const char *name = 0);

    MediaFileItem *next( bool reverse=false, bool loop=false );
    MediaFileItem *start( bool reverse=false );
    void reset();
    MediaFileItem *active() { return static_cast<MediaFileItem*>(_active); };
    MediaFileItem *shuffle();

    MediaFileItem *addNewItem( const KURL &url, QListViewItem *after );

 signals:
    void play( MediaFile *file );
    void stop();

 public slots:
    void playSelected();
    void removeSelected();
    void stopLoading();

 protected slots:
    void menu(KListView* l, QListViewItem* i, const QPoint& p);
    void droppedFile(QDropEvent *ev, QListViewItem *parent, QListViewItem *after);
    bool acceptDrag(QDropEvent *event) const;
    void playItem( QListViewItem *item );
    void updateID3Tag( const QList<ID3Tag> &tags );

 protected:
    virtual void keyPressEvent( QKeyEvent *ev );

 private:
    void setActive( QListViewItem *item );

    QListViewItem *_active;
    KURL *_fileName;
    ID3Reader _ID3Reader;
};


class MediaManager : public MediaManagerBase
{
 Q_OBJECT
 public:  
    MediaManager( const QString &title, const char *name=0 );
    ~MediaManager();

    MediaFile *next( bool reverse=false, bool loop=false );
    MediaFile *start( bool reverse );
    void reset();
    MediaFile *active();
    MediaFile *shuffle();    
    int count();
    int position();

    KURL fileName() { return _fileName; };
    QString aRtsFileMask();
     
 public slots:
    void clear();
    void addURL( const KURL &url, bool update=true );
    void addPlaylist( const KURL &url, bool update=true );
    void loadPlaylist( const KURL &url );
    bool savePlaylist( const KURL &url );
    void addDirectory( const KURL &url );

    void addFiles();
    void addDir();

    void open();
    void save();
    void saveAs();
    void openNew();
    void stopLoading();

 protected slots:
    void dirListerNewItems( const KFileItemList & items );
    void dirListerCompleted();

 private:
    void initFileExtensions();
    QString allFilesFilter();

    MediaListView *_list;
    KURL _fileName;
    KURL _baseURL;
    KDirLister *_dirLister;
    QStringList _fileExtensions;
    QQueue<KURL> _dirQueue;
    QStringList _addedDirs;
    QString _title;
};


#endif
