/*
  defines the format of an audio stream
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "audioTime.h"



AudioTime::AudioTime(){
  time=0.0;
}


AudioTime::~AudioTime() {
}


void AudioTime::setFormat(int stereo,int samplesize,int speed) {
  setStereo(stereo);
  setSampleSize(samplesize);
  setSpeed(speed);
  
}


int AudioTime::getStereo() {
  return stereo;
}


int AudioTime::getSampleSize() {
  return samplesize;
}


int AudioTime::getSpeed() {
  return speed;
}

void AudioTime::setStereo(int stereo) {
  this->stereo=stereo;
}


void AudioTime::setSampleSize(int samplesize) {
  this->samplesize=samplesize;
}


void AudioTime::setSpeed(int speed) {
  this->speed=speed;
}

float AudioTime::getTime() {
  return time;
}


void AudioTime::setTime(float time) {
  this->time=time;
}


void AudioTime::forwardTime(int bytes){
  time+=calculateTime(bytes);
}


float AudioTime::calculateTime(int bytes) {
  float back=0;


  if (samplesize == 16) {
    bytes=bytes/2;
  }
  if (stereo==1) {
    bytes=bytes/2;
  }
  if (speed != 0) {
    back=(float)bytes/(float)speed;
  }
  return back;
}


/**
   How much byte we need for time usecs?
*/
int AudioTime::calculateBytes(float time) {
  float back=time;

  if (speed != 0) {
    back=back*(float)speed;
  }
  if (samplesize == 16) {
    back=back*2.0;
  }
  if (stereo==1) {
    back=back*2.0;
  }
  return (int)back;
}



void AudioTime::sleepWrite(int size) {
  struct timeval time;
  float timeLength=calculateTime(size);
  time.tv_sec=(time_t)timeLength;
  time.tv_usec=(time_t)(1000000*(timeLength-time.tv_sec));
  select(0,NULL,NULL,NULL,&time);

}


void AudioTime::print() {
  cout << "AudioTime-begin-"<<endl;
  cout << "stereo:"<<getStereo()<<" sampleSize:"<<getSampleSize()
       << " speed: "<<getSpeed()<<endl;

  cout << "AudioTime-end-"<<endl;
 
}


void AudioTime::copyTo(AudioTime* dest) {
  dest->setStereo(getStereo());
  dest->setSampleSize(getSampleSize());
  dest->setSpeed(getSpeed());
}

