/*
  bitwindow class
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __MPEGBITWINDOW_H
#define __MPEGBITWINDOW_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#ifndef WORDS_BIGENDIAN
#define _KEY 0
#else
#define _KEY 3
#endif



#define WINDOWSIZE    4096
#define BITWINDOWSIZE    (WINDOWSIZE*8)


class MpegAudioBitWindow {

  int  point,bitindex;
  char buffer[2*WINDOWSIZE];

 public:
  MpegAudioBitWindow(){bitindex=point=0;}

  void initialize(void)  {bitindex=point=0;}
  int  gettotalbit(void) const {return bitindex;}

  void putbyte(int c)    {buffer[point&(WINDOWSIZE-1)]=c;point++;}
  void wrap(void);
  void rewind(int bits)  {bitindex-=bits;}
  void forward(int bits) {bitindex+=bits;}
  int  getbit(void);
  int  getbits9(int bits);
  int  getbits(int bits);
  

};
#endif
