/*
  abstraction for threads
  Copyright (C) 2000 Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "abs_thread.h"


// START SDL


#ifdef __SDL_WRAPPER


// SDL SUPPORT DISABLED 



// SIGNAL FUNCTIONS
// note we have _no_ cond attribut (not needed)
int abs_thread_cond_init(abs_thread_cond_t* cond);
int abs_thread_cond_destroy(abs_thread_cond_t *cond);

int abs_thread_cond_signal(abs_thread_cond_t* cond);

int abs_thread_cond_wait(abs_thread_cond_t* cond,
			 abs_thread_mutex_t *mutex);
// CREATE / JOIN THREAD
// Note: we have thread attribute
int abs_thread_create(abs_thread_t* thread,
		      void * (*start_routine)(void *), void * arg);

int abs_thread_join(abs_thread_t th, 
		    void **thread_return);


// MUTEX FUNCTIONS

int abs_thread_mutex_lock(abs_thread_mutex_t *mutex);
int abs_thread_mutex_trylock(abs_thread_mutex_t *mutex);
int abs_thread_mutex_unlock(abs_thread_mutex_t *mutex);
// not attribute!
int abs_thread_mutex_init(abs_thread_mutex_t   *mutex);

int abs_thread_mutex_destroy(abs_thread_mutex_t *mutex);









#include <SDL/SDL_thread.h>

// currently we have not try_lock in SDL *HACK!*
#include <pthread.h>
#include <SDL/SDL_mutex.h>

// SDL has no try_lock, we build it here
typedef struct SDL_MY_mutex {
  SDL_mutex* protect;
  int cnt;
  SDL_mutex* lock;

} SDL_MY_mutex;
#define _ABS_BUSY  1

typedef SDL_MY_mutex abs_thread_mutex_t;
typedef SDL_cond*  abs_thread_cond_t;
typedef SDL_Thread* abs_thread_t;



int abs_thread_cond_init(abs_thread_cond_t* cond) {
  *cond=SDL_CreateCond();
  return (*cond != NULL);
}

int abs_thread_cond_destroy(abs_thread_cond_t *cond) {
  SDL_DestroyCond(*cond);
  return true;
}


int abs_thread_cond_signal(abs_thread_cond_t* cond) {
  
  return SDL_CondSignal(*cond);
}


int abs_thread_cond_wait(abs_thread_cond_t* cond,
			 abs_thread_mutex_t* mutex) {
  SDL_CondWait(*cond,mutex->lock);
  return true;
}


// CREATE / JOIN THREAD
int abs_thread_create(abs_thread_t* thread,
		      void * (*start_routine)(void *), void * arg) {
  int (*func)(void *);
  func=(int (*)(void *))start_routine;
  *thread=SDL_CreateThread(func,arg);
  return (*thread != NULL);
}

int abs_thread_join(abs_thread_t th, 
		    void **thread_return) {
  SDL_WaitThread(th,(int*)*thread_return);
  return true;
}


// MUTEX FUNCTIONS

int abs_thread_mutex_lock(abs_thread_mutex_t *mutex) {
  SDL_LockMutex(mutex->protect);
  mutex->cnt++;
  SDL_UnlockMutex(mutex->protect);
  return SDL_LockMutex(mutex->lock);
}


int abs_thread_mutex_trylock(abs_thread_mutex_t *mutex) {
  int back;
  SDL_LockMutex(mutex->protect);
  if (mutex->cnt > 0) {
    back=_ABS_BUSY;
  } else {
    if (mutex->cnt != 0) {
      cout << "mutex cnt error"<<endl;
    }
    back=0;
    mutex->cnt++;
    SDL_LockMutex(mutex->lock);
  }
  SDL_UnlockMutex(mutex->protect);
  return back;
}


int abs_thread_mutex_unlock(abs_thread_mutex_t *mutex) {
  SDL_LockMutex(mutex->protect);
  mutex->cnt--;
  SDL_UnlockMutex(mutex->protect);
  return SDL_UnlockMutex(mutex->lock);
}


int abs_thread_mutex_init(abs_thread_mutex_t   *mutex) {
  mutex->protect=SDL_CreateMutex();
  mutex->lock=SDL_CreateMutex();
  mutex->cnt=0;
  return true;
}


int abs_thread_mutex_destroy(abs_thread_mutex_t *mutex) {
  SDL_DestroyMutex(mutex->protect);
  SDL_DestroyMutex(mutex->lock);
  return true;
}



#endif
