/*
  a wrapper for the audioDevice.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <audioWrapper.h>


AudioWrapper::AudioWrapper() {
  lopenDevice=false;
  lopenMixer=false;
  samplesize=-1;
  speed=-1;
  stereo=-1;
  audioConstruct();
}

AudioWrapper::~AudioWrapper() {
  if (lopenDevice) {
    audioClose();
  }
  if (lopenMixer) {
    mixerClose();
  }
  audioDestruct(); 
}
 

int AudioWrapper::isOpenDevice() {
  return lopenDevice;
}

int AudioWrapper::openDevice() {
  if (lopenDevice==true) {
    return true;
  }
  lopenDevice=audioOpen();
  return lopenDevice;
}  
 
int AudioWrapper::closeDevice() {
  if (isOpenDevice() == true) {
    audioClose();
    lopenDevice=false;
  }
  return true;
}


int AudioWrapper::isOpenMixer() {
  return lopenMixer;
}


int AudioWrapper::getBufferSize() {
  return getAudioBufferSize();
}


int AudioWrapper::openMixer() {
  lopenMixer=mixerOpen();
  return lopenMixer;
}  
 
int AudioWrapper::closeMixer() {
  if (isOpenMixer() == true) {
    mixerClose();
    lopenMixer=false;
  }
  return true;
}

    
int AudioWrapper::isEqual(int samplesize,int speed,int stereo) {
  if (this->samplesize != samplesize) {
    return false;
  }
  if (this->speed != speed) {
    return false;
  }
  if (this->stereo != stereo) {
    return false;
  }
  return true;
    
}


void AudioWrapper::init(int sampleSize,int speed,int stereo) {

  if (isOpenDevice()) {
    audioInit(sampleSize,speed,stereo);
    this->samplesize=sampleSize;
    this->speed=speed;
    this->stereo=stereo;
  } else {
    cout << "cannot init AudioDevice->not open!"<<endl;
  }
}


int AudioWrapper::write(char* buf,int len) {
  return audioWrite(buf,len);
}


void AudioWrapper::setVolume(float leftPercent,float rightPercent) {
  if (isOpenMixer()) {
    mixerSetVolume((int)leftPercent,(int)rightPercent);
  } else {
    cout << "cannot set Mixer settings:not open!"<<endl;
  }   
}


void AudioWrapper::print() {
  cout<<"lopenDevice:"<<lopenDevice<<endl;
  cout<<"lopenMixer:"<<lopenMixer<<endl;
  cout<<"samplesize:"<<samplesize<<endl;
  cout<<"speed:"<<speed<<endl;
  cout<<"stereo:"<<stereo<<endl;

}
