/*
  copys RGB images to a destination
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "ditherRGB.h"


DitherRGB::DitherRGB() {
}


DitherRGB::~DitherRGB() {
}


void DitherRGB::ditherRGBImage(unsigned char* dest,unsigned char* src,
			       int depth,int width,int height,int offset) {
  int byteDepth;

  switch(depth) {
  case 8:
    byteDepth=1;
    break;
  case 15:
  case 16:
    byteDepth=2;
    break;
  case 24:
  case 32:
    byteDepth=4;
    break;
  default:
    cout << "unknown byteDepth:"<<depth
         << " in DitherRGB_flipped::flipRGBImage"<<endl;
    return;
  }
  
  if (offset==0) {
    int bytes=height*width*byteDepth;
    memcpy(dest,src,bytes);
    return;
  }

  int i;
  int lineSize=width*byteDepth;
  
  offset=offset*byteDepth+lineSize;

  for (i=0;i<height;i++) {
    memcpy(dest,src,lineSize);
    src+=lineSize;
    dest+=offset;
  }

  
}

