/*
  xfree 4.0 XV extension desk mode
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "imageXVDesk.h"


ImageXVDesk::ImageXVDesk(XWindow* xWindow) {

  this->xWindow=xWindow;
  lSupport=false;

#ifndef X11_XV
  return;
#endif

#ifdef X11_XV
  xv_port=-1;
  shmem_flag = 0;
  yuv_image=NULL;
  yuv_shminfo.shmaddr=NULL;
  yuv_shminfo.shmid=-1;
  
  if (XShmQueryExtension(xWindow->display)) shmem_flag = 1;
  if (!shmem_flag) {
    printf("no shmem available.\n");
    return;
  }
  

  if (haveXVSupport(xWindow)==true) {
    lSupport=true;
  } else {
    return;
  }


  yuv_image = XvShmCreateImage(xWindow->display, xv_port, 
			       GUID_YUV12_PLANAR, 0, 
			       xWindow->width,
			       xWindow->height, &yuv_shminfo);

  yuv_shminfo.shmid = shmget(IPC_PRIVATE, 
			     yuv_image->data_size, IPC_CREAT | 0777);
  yuv_shminfo.shmaddr = yuv_image->data = (char*)shmat(yuv_shminfo.shmid, 0, 0);
  yuv_shminfo.readOnly = False;
  
  if (!XShmAttach(xWindow->display, &yuv_shminfo)) {
    printf("XShmAttach failed !\n");
    lSupport=false;
    return;
  }
  XSync(xWindow->display, False);
  shmctl(yuv_shminfo.shmid, IPC_RMID, 0);

  int i;
  int j;

  // test image, is later overwritten
  for (i = 0; i < yuv_image->height; i++) {
    for (j = 0; j < yuv_image->width; j++) {
      yuv_image->data[yuv_image->width*i + j] = i*j;
    }
  }
  
  printf("%d\n", yuv_image->data_size);
  
#endif
}


ImageXVDesk::~ImageXVDesk() {
#ifdef X11_XV
  if (yuv_shminfo.shmid >=0) {
    XShmDetach(xWindow->display,&yuv_shminfo);
    if(yuv_shminfo.shmaddr) {
      shmdt(yuv_shminfo.shmaddr);
      XFree(yuv_image);
    }
    XSync(xWindow->display, False);
  }
#endif
}

int ImageXVDesk::support() {
  return lSupport;
}

int ImageXVDesk::openImage(int ) {
  return true;
}


int ImageXVDesk::closeImage() {
  return true;
}


void ImageXVDesk::ditherImage(YUVPicture* pic) {

#ifdef X11_XV
  int x_return;
  int y_return;
  unsigned int	border_width_return;
  unsigned int	depth_return;
  unsigned int  _w;
  unsigned int  _h;
  Window	_dw;

  int inputType=pic->getImageType();
  if ( (inputType == PICTURE_RGB) ||
       (inputType == PICTURE_RGB_FLIPPED) ){
    cout << "xv for rgb not implemented"<<endl;
    return;
  }


  XGetGeometry(xWindow->display,(Drawable)xWindow->window,
	       &_dw, &x_return, &y_return, &_w, &_h,
	       &border_width_return, &depth_return);
      
  // Maybe the yuv format is not supported ??

  // we (currently) cannot create yuvPicture _in_
  // the shared segment here we copy it
  int w=yuv_image->width;
  int h=yuv_image->height;
  int size=w*h+(w*h)/2;

  unsigned char* lum=pic->getLuminancePtr();

  memcpy(yuv_image->data,lum,size);


  XvShmPutImage(xWindow->display, xv_port,xWindow->window,
		xWindow->gc, yuv_image,
		0, 0, yuv_image->width, yuv_image->height,
		0, 0, _w, _h, True);
  
  XSync(xWindow->display,true);
#endif
}


void ImageXVDesk::putImage() {

      
}



int ImageXVDesk::haveXVSupport(XWindow* xWindow) {
#ifdef X11_XV
  int ret;
  unsigned int		p_version=0;
  unsigned int          p_release=0;
  unsigned int          p_request_base=0;
  unsigned int          p_event_base=0;
  unsigned int          p_error_base=0;

  unsigned int		p_num_adaptors=0;

  /**------------------------------- XV ------------------------------------*/
  
  /** query and print Xvideo properties */

  ret = XvQueryExtension(xWindow->display, 
			 &p_version, &p_release, &p_request_base,
			 &p_event_base, &p_error_base);
  if (ret != Success) {
    if (ret == XvBadExtension) {
      printf("XvBadExtension returned at XvQueryExtension.\n");
    } else if (ret == XvBadAlloc) {
      printf("XvBadAlloc returned at XvQueryExtension.\n");
    } else {
      printf("other error happened at XvQueryExtension.\n");
    }
    return false;
  }
  /*
    printf("========================================\n");
    printf("XvQueryExtension returned the following:\n");
    printf("p_version      : %u\n", p_version);
    printf("p_release      : %u\n", p_release);
    printf("p_request_base : %u\n", p_request_base);
    printf("p_event_base   : %u\n", p_event_base);
    printf("p_error_base   : %u\n", p_error_base);
    printf("========================================\n");
  */
  
  ret = XvQueryAdaptors(xWindow->display, DefaultRootWindow(xWindow->display),
			&p_num_adaptors, &ai);
  
  if (ret != Success) {
    if (ret == XvBadExtension) {
      printf("XvBadExtension returned at XvQueryExtension.\n");
    } else if (ret == XvBadAlloc) {
      printf("XvBadAlloc returned at XvQueryExtension.\n");
    } else {
      printf("other error happaned at XvQueryAdaptors.\n");
    }
    return false;
  }
  /*
  printf("=======================================\n");
  printf("XvQueryAdaptors returned the following:\n");
  printf("%d adaptors available.\n", p_num_adaptors);
  */
  if (p_num_adaptors == 0) {
    cout << "no adaptors found. XV not possible"<<endl;
    return false;
  }

  unsigned int i;
  unsigned int j;

  for (i = 0; i < p_num_adaptors; i++) {
    /*
      printf(" name:        %s\n"
      " type:        %s%s%s%s%s\n"
      " ports:       %ld\n"
      " first port:  %ld\n",
      ai[i].name,
      (ai[i].type & XvInputMask)	? "input | "	: "",
      (ai[i].type & XvOutputMask)	? "output | "	: "",
      (ai[i].type & XvVideoMask)	? "video | "	: "",
      (ai[i].type & XvStillMask)	? "still | "	: "",
      (ai[i].type & XvImageMask)	? "image | "	: "",
      ai[i].num_ports,
      ai[i].base_id);
    */
    xv_port = ai[i].base_id;
    
    //printf("adaptor %d ; format list:\n", i);
    for (j = 0; j < ai[i].num_formats; j++) {
      /*
	printf(" depth=%d, visual=%ld\n",
	ai[i].formats[j].depth,
	ai[i].formats[j].visual_id);
      */
    }
    unsigned int p;
    unsigned int encodings;
    int attributes;
    int formats;

    for (p = ai[i].base_id; p < ai[i].base_id+ai[i].num_ports; p++) {
      
      //printf(" encoding list for port %d\n", p);
      if (XvQueryEncodings(xWindow->display, p, &encodings, &ei) != Success) {
	//printf("XvQueryEncodings failed.\n");
	continue;
      }
      for (j = 0; j < encodings; j++) {
	/*
	printf("  id=%ld, name=%s, size=%ldx%ld, numerator=%d, denominator=%d\n",
	       ei[j].encoding_id, ei[j].name, ei[j].width, ei[j].height,
	       ei[j].rate.numerator, ei[j].rate.denominator);
	*/
      }
      XvFreeEncodingInfo(ei);
      int k;
      //printf(" attribute list for port %d\n", p);
      at = XvQueryPortAttributes(xWindow->display, p, &attributes);
      for (k = 0; k < attributes; k++) {
	/*
	printf("  name:       %s\n"
	       "  flags:     %s%s\n"
	       "  min_color:  %i\n"
	       "  max_color:  %i\n",
	       at[k].name,
	       (at[k].flags & XvGettable) ? " get" : "",
	       (at[k].flags & XvSettable) ? " set" : "",						
	       at[k].min_value, at[k].max_value);
	*/
      }
      if (at)
	XFree(at);
      
      //printf(" image format list for port %d\n", p);
      fo = XvListImageFormats(xWindow->display, p, &formats);
      for (k = 0; k < formats; k++) {
	/*
	printf("  0x%x (%4.4s) %s\n",
	       fo[k].id,
	       (char *)&fo[k].id,
	       (fo[k].format == XvPacked) ? "packed" : "planar");
	*/
      }
      if (fo)
	XFree(fo);
    }
    printf("\n");
  }
  if (p_num_adaptors > 0)
    XvFreeAdaptorInfo(ai);
  if (xv_port == -1) {
    return false;
  }
#endif
  return true;
  
}
