
/**
   Starter for plugins.
   The plugins are identified by their extension

   .wav ->WavPlayObject
   .mp3 ->MP3PlayObject
   .mpg ->MPGPlayObject
   .ogg ->OGGPlayObject
*/


#include "soundserver.h"
#include "kmedia2.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <string>
#include <iostream>

using namespace std;
using namespace Arts;

#if defined(HAVE_GETOPT_H) 
#include <getopt.h>
#endif


char* filename1=NULL;
char* filename2=NULL;
Dispatcher* d=NULL;
SimpleSoundServer* server=NULL;
PlayObject* play=NULL;



void usage() {
  cout << "mpeglibartsply command line tool for arts playobjects"<<endl;
  cout << "Usage : mpeglibartsply [url]"<<endl;
  cout << endl;
  cout << "-1 : stress test."<<endl;
  cout << "-2 : re-open test"<<endl;
  cout << "-3 : smooth mixing start test (use arts -F 4 -S 4096!)"<<endl;
  cout << "-4 : create/destroy test (on stack)"<<endl;
  cout << "-5 : create/destroy test (on heap)"<<endl;
  cout << "-h : help"<<endl;
  cout << endl;
  cout << "THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY! " \
       << "USE AT YOUR OWN RISK!"<<endl;
  cout << endl;
  exit(0);
}


void initServer() {
  d=new Dispatcher();
  server= new SimpleSoundServer (Reference("global:Arts_SimpleSoundServer"));
  
  if(server->isNull()) {
    cerr << "Can't connect to sound server" << endl;
    exit(0);
  }

}

void initPlayObject() {
  play=new PlayObject();
  *play=server->createPlayObject(filename1);
}

void destroyPlayObject() {
  delete play;
}

void destroyServer() {
  delete server;
  delete d;
}

/**
   Simple stress. play short time. seek play short time. end.
*/
void doStress1(int wait1,int wait2) {
  cout << "doStress1 "<<endl;
  play->play();
  poTime seekTime;
  poTime totalTime;
  cout << "sleep:"<<wait1<<endl;
  sleep(wait1);
  totalTime=play->overallTime();
  seekTime.seconds=totalTime.seconds/2;
  cout << "seek:"<<seekTime.seconds<<endl;
  play->seek(seekTime);
  cout << "sleep:"<<wait2<<endl;
  sleep(wait2);
}


void doTest3() {
  PlayObject* play2=new PlayObject();
  *play2=server->createPlayObject(filename2);
  play->play();
  sleep(5);
  cout << "insert next stream (should be no clicks)"<<endl;
  play2->play();
  sleep(5);
  cout << "halting stream (should be no clicks)"<<endl;
  play->halt();
  sleep(5);
  cout << "removing stream"<<endl;
  delete play2;
}

/**
   loop

          createPlayObject
          play
          halt
   endloop
*/

void doTest4() {
  int cnt=0;
  PlayObject play3;
  
  while (cnt < 10000) {
    if ((cnt % 2) == 0) {
      play3=server->createPlayObject(filename2);
    } else {
      play3=server->createPlayObject(filename1);
    }
    play3.play();
    usleep(1000);
    Arts::poTime l_t_zero(0,0,0,"samples");
    play3.seek(l_t_zero);

    play3.halt();
    // make here a comment and then you get a segfault
    play3 = Arts::PlayObject::null();
    cnt++;
    cout << "test4 cnt:"<<cnt<<endl;
  }
  play3=server->createPlayObject(filename2);
  play3.play();
  sleep(20);

}

void doTest5() {
  int cnt=0;
  PlayObject* play3;
  while (cnt < 10000) {
    play3=new PlayObject();
   
    if ((cnt % 2) == 0) {
      *play3=server->createPlayObject(filename2);
    } else {
      *play3=server->createPlayObject(filename1);
    }
    play3->play();
    Arts::poTime l_t_zero(0,0,0,"samples");
    play3->seek(l_t_zero);

    play3->halt();
    // make here a comment and then you get a segfault
    delete play3;
    cnt++;
    cout << "test5 : cnt:"<<cnt<<endl;
  }
  play3=new PlayObject();
  *play3=server->createPlayObject(filename1);
  play3->play();
  delete play3;
}


int main(int argc, char **argv) {
  int testNr=0;
  int c;
  
  while(1) { 
    c = getopt (argc, argv, "12345h");
    if (c == -1) break;
    switch(c) {
    case '1': {    
      testNr=1;
      break;
    }
    case '2': {
      testNr=2;
      break;
    }
    case '3': {
      testNr=3;
      break;
    }
    case '4': {
      testNr=4;
      break;
    }
    case '5': {
      testNr=5;
      break;
    }
    case 'h': {
      usage();
      break;
    }
    default:
      printf ("?? getopt returned character code 0%o ??\n", c);
      usage();
      exit(-1);
    }
  }

  if (optind < argc ) {
    filename1=argv[optind];
    optind++;
    filename2=filename1;
  }
  if (optind < argc ) {
    filename2=argv[optind];
  }  

  initServer();
  initPlayObject();



  switch(testNr) {
  case 1: {
    doStress1(5,10);
    destroyPlayObject();
    destroyServer();
    exit(0);
  }
  case 2: {
    int cnt=1;
    while (cnt < 3) {
      play->play();
      sleep(15);
      // now re-init the playObject
      play->halt();
      cout << "loadMedia -s"<<endl;
      if ((cnt % 2) == 0) {
	play->loadMedia(filename1);
      } else {
	play->loadMedia(filename2);
      }

      cout << "loadMedia -e"<<endl;
      play->play();
      cnt++;
    }
    destroyPlayObject();
    destroyServer();
    exit(0);
  }
     
      
  case 3: {
    doTest3();
    destroyPlayObject();
    destroyServer();
    exit(0);
  }
  case 4: {
    doTest4();
    destroyPlayObject();
    destroyServer();
    exit(0);
  }
  case 5:{
    doTest5();
    destroyPlayObject();
    destroyServer();
    exit(0);
  }
  }
  play->play();

  while (play->state() != posIdle) {
    sleep(1);
  }
  cout << "playing ready"<<endl;
  sleep(5);

  destroyPlayObject();
  destroyServer();
  exit(0);
}
