/*
  class for ogg-mpeglib decoder
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include "oggPlayObject_impl.h"
#include "debug.h"




OGGPlayObject_impl::OGGPlayObject_impl() {
  arts_debug("OGGPlayObject_impl");
}

OGGPlayObject_impl::~OGGPlayObject_impl() {
  arts_debug("~OGGPlayObject_impl");
}


DecoderPlugin* OGGPlayObject_impl::createPlugin() {
  cout << "OGGPlayObject_impl::getPlugin"<<endl;
  DecoderPlugin* vorbisPlugin;
  // load vorbis lib dynamic
  void *handle = dlopen ("libvorbis_kmpg.so", RTLD_LAZY);
  if (!handle) {
    fputs (dlerror(), stderr);
    cout << endl;
    cout << "******** no libvorbis_kmpg.so found !! decoding impossible"<<endl;
  } else {
    cout << "dynamic load successful"<<endl;
  }
  char* error;

  if (handle) {
    cout << "getVorbisPlayer start"<<endl;
    DecoderPlugin* (*getPlugin)()=
      (DecoderPlugin *(*)())dlsym(handle,"getVorbisPlayer");
    // ^^^^^^^^^^^^^^^^^^^^^
    // only as side note: this is a function cast !!!


    if ((error = dlerror()) != NULL)  {
      fputs(error, stderr);
      vorbisPlugin=new DecoderPlugin();
    } else {
      cout << "we have vorbis!"<<endl;
      vorbisPlugin=(*getPlugin)();
    }
  } else {
    vorbisPlugin=new DecoderPlugin();
  }
 
  return vorbisPlugin;
}

void OGGPlayObject_impl::calculateBlock(unsigned long samples) {
  DecoderBaseObject_impl::calculateBlock(samples,left,right);
}



REGISTER_IMPLEMENTATION(OGGPlayObject_impl);

