// -*- c++ -*-

#ifndef KRFBCANVAS_H
#define KRFBCANVAS_H

#include <qscrollview.h>
#include <kurl.h>

class KRFBConnection;
class KRecentFilesAction;

/**
 * Displays data from an KRFBDecoder, and sends events to the
 * KRFBConnection.
 */
class KRFBCanvas : public QScrollView
{
  Q_OBJECT
public:
  KRFBCanvas( QWidget *parent, const char *name=0 );
  ~KRFBCanvas();

  void setConnection( KRFBConnection * );
  KRFBConnection *connection() { return connection_; };

  // Actions
  KAction *connectAction;
  KAction *disconnectAction;
  KAction *refreshAction;
  KAction *saveSnapshotAction;
  KRecentFilesAction *recentAction;

signals:
  void statusChanged( const QString &msg );

public slots:
  void openConnection();
  void openURL( const KURL & );
  void closeConnection();
  void error( const QString & );
  void passwordRequired( KRFBConnection * );
  void connected();
  void loggedIn();

  void refresh();
  void bell();
  void saveSnapshot();

protected:
  virtual void keyPressEvent( QKeyEvent * );
  virtual void keyReleaseEvent( QKeyEvent * );
  virtual void contentsMousePressEvent( QMouseEvent * );
  virtual void contentsMouseReleaseEvent( QMouseEvent * );
  virtual void contentsMouseMoveEvent( QMouseEvent * );

  virtual void viewportPaintEvent( QPaintEvent *e );

protected slots:
  void viewportUpdate( int x, int y, int w, int h );

private:
  KRFBConnection *connection_;
  bool loggedIn_;
};

#endif // KRFBCANVAS_H
