/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: cupsprinter.c
 *
 * Description: Implementation of the APS_CUPS_PRINTER_OBJECT methods.
 *
 */
#include "apsinternal.h"
#if (APSCFG_CUPS_BUILD)

#include <stdlib.h>

#include "aps.h"
#include "cupsprinter.h"

DEBUG_CHANNEL_DEFAULT(cups)

/* Virtual functions that operate on an CUPS printer. */
void CupsDestructor(Printer * thisBase);

PrinterVtbl cups_printer_vtbl = {
    CupsDestructor
};

/* Creates a new CUPS Printer object */
extern CupsPrinter *CupsCreatePrinter(char *name, void *transport);

/* ---------------------------------------------------------------------------
 * CupsCreatePrinter()
 *
 * Creates a new CupsPrinter object.
 *
 * Parameters: name      - The name of the printer to be created.
 *
 *             transport - Must be a pointer to the CupsTransport that will
 *                         be dealing with this printer.
 *
 *     Return: A pointer to a CupsPrinter, or NULL on failure.
 */
CupsPrinter *CupsCreatePrinter(char *name, void *transport)
{
    CupsPrinter *printer = (CupsPrinter *) calloc(1, sizeof(CupsPrinter));

    if (printer == NULL)
        return (NULL);

    /* Setup pointer to virtual function table */
    printer->baseClass.vtbl = &cups_printer_vtbl;

    /* Call the generic printer initialization function. */
    if (PrinterInitialize((Printer *) printer, name, transport)
        != APS_SUCCESS) {
        /* We failed to initialize the printer ... */
        free(printer);
        return (NULL);
    }
    /* Return a pointer to the newly created object */
    return (printer);
}

/* ---------------------------------------------------------------------------
 * CupsDestructor()
 *
 * Called when an CupsPrinter instance is being deleted.
 *
 * Parameters: thisBase - A pointer to the printer object being deleted.
 *
 *     Return: void
 */
void CupsDestructor(Printer * thisBase)
{
}
#endif /* APSCFG_CUPS_BUILD */
