/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: lprprinter.c
 *
 * Description: Implementation of the APS_LPR_PRINTER_OBJECT methods.
 *
 */
#include "apsinternal.h"
#if (APSCFG_LPR_BUILD)

#include <stdlib.h>

#include "aps.h"
#include "lprprinter.h"

DEBUG_CHANNEL_DEFAULT(lpr)

/* Virtual functions that operate on an lpr printer. */
void LprDestructor(Printer * thisBase);

PrinterVtbl lpr_printer_vtbl =
{
    LprDestructor
};

/* ---------------------------------------------------------------------------
 * LprCreatePrinter()
 *
 * Creates a new LprPrinter
 *
 * Parameters: name      - The name of the printer to be created.
 *
 *             transport - Must be a pointer to the LprTransport that will
 *                         be dealing with this printer.
 *
 *     Return: A pointer to a LprPrinter, or NULL on failure.
 */
LprPrinter *LprCreatePrinter(const char *name, void *transport)
{
    /* Allocate memory for new object. */
    LprPrinter *printer = (LprPrinter *) calloc(1, sizeof(LprPrinter));

    if (printer == NULL)
        return (NULL);

    /* Setup pointer to virtual function table. */
    printer->baseClass.vtbl = &lpr_printer_vtbl;

    /* Call the generic printer initialization function. */
    if (!Aps_Succeeded(PrinterInitialize((Printer *) printer, name,
                       transport))) {
        /* We failed to initialize the printer ... */
        free(printer);
        return (NULL);
    }

    /* We return a pointer to the newly created object. */
    return (printer);
}

/* ---------------------------------------------------------------------------
 * LprDestructor()
 *
 * Called when an LprPrinter instance is being deleted.
 *
 * Parameters: thisBase - A pointer to the printer object being deleted.
 *
 *     Return: void
 */
void LprDestructor(Printer * thisBase)
{
}

#endif /* APSCFG_LPR_BUILD */
