/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: parseprintcapfile.h
 *
 * Description: Public definitions of the interface to the printcap parser.
 *              The /etc/printcap file contains the printer configuration
 *              information used by lpr, LPRng and work-alikes.
 */

#ifndef PARSEPRINTCAPFILE_H
#define PARSEPRINTCAPFILE_H

#include "apsinternal.h"

/* Structure containing the information from a single printer's entry */
/* in the printcap file.                                              */
typedef struct Aps_Printcap_Info_ {
    int size;

    char *printerName;

    BOOL defaultPrinter;

    char *accountingFile;       /* af - NULL */
    int baudRate;               /* br - if(lp == tty) NONE else set br by using ioctl(2) call */
    char *cifplotFilter;        /* cf - NULL */
    char *dftestDataFilter;     /* df  - NULL */
    int isTTY;                  /* fc - 0 */
    char *formFeed;             /* ff - NULL */
    BOOL formFeedOnOpen;        /* fo - FALSE */
    int isTTYBits;              /* fs - 0 */
    char *graphDataFilter;      /* gf - NULL */
    BOOL headerPageLast;        /* hl - FALSE */
    BOOL ioctlSupport;          /* ic - FALSE */
    char *textFilter;           /* if - NULL */
    char *logFile;              /* lf - /dev/console */
    char *lockFile;             /* lo - lock */
    char *deviceName;           /* lp /dev/lp */
    int maxFileSize;            /* mx - 1000 */
    char *nextDirectory;        /* nd - NULL */
    char *ditroffFilter;        /* nf - NULL */
    char *outputFilter;         /* of - NULL */
    int pricePerFoot;           /* pc - 200 */
    int pageLengthInLines;      /* pl - 66 */
    int pageWidthInChars;       /* pw - 132 */
    int pageWidthInPixels;      /* px - 0 */
    int pageLengthInPixels;     /* py - 0 */
    char *fortranStyleFileFilter;	/* rf - NULL */
    char *restrictedGroup;      /* rg - NULL */
    char *remoteMachine;        /* rm - NULL */
    char *remotePrinterArgument;	/* rp - "lp" */
    BOOL restrictToRemoteUsersWithLocalAcc;	/* rs - FALSE */
    BOOL openPrinterDeviceForReadWrite;	/* rw - FALSE */
    BOOL shortBanner;           /* sb - FALSE */
    BOOL suppressMultipleCopies;	/* sc - FALSE */
    char *spoolDirectory;       /* sd - /var/spool/lpd */
    BOOL supressFormFeed;       /* sf - FALSE */
    BOOL suppressBurstPageHeader;	/* sh - FALSE */
    char *statusFileName;       /* st - status */
    char *troffDataFilter;      /* tf - NULL */
    char *trailingString;       /* tr - NULL */
    char *rasterImageFilter;    /* vf - NULL */

} Aps_Printcap_Info;



/* Enumeration for printcap option types recognized by the parser. */
typedef enum {
    OPTION_UNKNOWN,
    OPTION_ACCOUNTING_FILE,
    OPTION_BAUD_RATE,
    OPTION_CIFPLOT_FILTER,
    OPTION_TEST_DATA_FILTER,
    OPTION_IS_TTY,
    OPTION_FORM_FEED,
    OPTION_FF_ON_OPEN,
    OPTION_IS_TTY_BITS,
    OPTION_IS_GRAPH_DATA_FILTER,
    OPTION_HEADER_PAGE_LAST,
    OPTION_IOCTL_SUPPORT,
    OPTION_TEXT_FILTER,
    OPTION_LOG_FILE,
    OPTION_LOCK_FILE,
    OPTION_DEVICE,
    OPTION_MAX_FILE_SIZE,
    OPTION_NEXT_DIRECTORY,
    OPTION_DITROFF_FILTER,
    OPTION_OUTPUT_FILTER,
    OPTION_PRICE_PER_FOOT,
    OPTION_LINES_PER_PAGE,
    OPTION_CHARS_ACROSS_PAGE,
    OPTION_PAGE_WIDTH_PIXELS,
    OPTION_PAGE_HEIGHT_PIXELS,
    OPTION_FORTRAN_STYLE_FILTER,
    OPTION_RESTRICTED_GROUP,
    OPTION_REMOTE_MACHINE,
    OPTION_REMOTE_PRINTER_ARGUMENT,
    OPTION_RESTRICT_TO_LOCAL_ACC,
    OPTION_READ_WRITE_DEVICE,
    OPTION_SHORT_BANNER,
    OPTION_SUPPRESS_COPIES,
    OPTION_SPOOL_DIR,
    OPTION_SUPPRESS_FORM_FEED,
    OPTION_SUPPRESS_BURST_PG_HDR,
    OPTION_STATUS_FILE,
    OPTION_TROFF_FILTER,
    OPTION_TRAILING_STRING,
    OPTION_RASTER_FILTER
} PRINTCAP_OPTION_TYPE;
int LoadLprPrintcapFile(FILE *fp, Aps_Printcap_Info *** printcapInfo);
Aps_Result WritePrinterEntriesInPrintcap(char *printcapFileName, 
                                         Aps_Printcap_Info **printcap,
                                         int numberOfPrintcapEntries);
void FreePrintcapInfoStructure(Aps_Printcap_Info * rec);

#endif /* PARSEPRINTCAPFILE_H */
