/* 
 * APS Application Print Services library
 * (C) Copyright 1999 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: apsdefs.h
 *
 * Description: Defines the input and output parameter headings for 
 *              each APS calls to be tested by the APS test program. 
 *
 */

// The ApsCallInfo structure stores the Aps call info
typedef struct {
        char *callName;		// Library call
        char *inputLabel1;	// Input Label 1
        char *inputLabel2;  	// Input Label2	
        char *inputLabel3; 	// Input Label 3 
        char *inputLabel4;  	// Input Label 4 	
        char *outputLabel1;  	// Output Label 1	
        char *outputLabel2;  	// Output Label 2	
        char *outputLabel3;  	// Output Label3	
        char *labelMultiLine;  	// Output Label3	
        int  noInputParam;	// Number of Input Parameters
        int  noOutputParam;	// Number of Input Parameters
        bool isMultiLine;	// If multi line edit required
}ApsCallInfo;

// Fill the info for the each call
ApsCallInfo callInfo[] = {
        {"Aps_DispatchJob", "Printer Handle", "Filename", "Format", 
                                      "Settings", "Job", "", "","",  4, 1,0},
        {"Aps_ReleaseHandle", "Handle", "", "", "", "", "", "", "", 1, 0, 0},
        {"Aps_GetResultText", "Prev Result Code","","","", "Result Text", 
                                                       "", "", "", 1, 1,0 },
		// The text and size will be taken care by the code
        {"Aps_OpenDefaultPrinter", "", "", "", "", "Printer Handle", "", 
                                                         "", "", 0, 1,0},
        {"Aps_GetPrinters", "", "" , "", "", "Printer Names", "Count", "", 
                                                              "",  0, 2, 0},
        {"Aps_OpenPrinter", "Printer Name", "", "", "", "Printer Handle", 
                                                       "", "", "", 1, 1, 0},
        {"Aps_GetDefaultJobSettings","", "", "", "", "", "", "", "", 0, 0, 0},
        {"Aps_SetDefaultJobSettings","","", "", "", "", "", "", "", 0, 0, 0},
        {"Aps_GetProperty","", "", "", "", "", "", "", "",  0, 0, 0},
        {"Aps_SetProperty","", "", "", "", "", "", "", "",  0, 0, 0},
        {"Aps_StartJob", "Printer Handle", "Format", "", "", "Job", 
                                             "Descriptor", "", "", 2, 2, 0},
        {"Aps_GetJobSettings","", "", "", "", "", "", "", "", 0, 0, 0},
        {"Aps_Write","Job Handle", "", "", "", "", "", "", "data", 1, 0, 1},
        {"Aps_GetJobStat","Job Handle", "", "", "", "State", "", "", "", 1, 
                                                                     1, 0},
        {"Aps_EndJob","Job Handle", "Release Handle", "", "", "", "", "", 
                                                              "", 2, 0, 0},
        {"Aps_CancelJob","Job", "Release Handle", "", "", "", "", "", "", 
                                                                   2, 0, 0},
        {"Aps_GetPrinterName","Printer Handle", "", "", "", "Name", "", "", 
                                                               "", 1, 1, 0},
        {"Aps_GetPPDFileName","Printer Handle", "", "", "", "PPD FileName", 
                                                       "", "", "", 1, 1, 0},
        {"Aps_PrinterSetAsDefault", "Printer Handle", "", "", "", "", "", 
                                                       "","",  1, 0,0},
        {"Aps_AddPrinter", "Printer Name", "Handle", "", "", "Handle", "", 
                                                            "","",  2, 1,0},
        {"Aps_PrinterRemove", "Handle", "", "", "", "", "", "","",  1, 0,0},
        {"Aps_PrinterIsDefault", "Handle", "", "", "", "IsDefault", "", "",
                                                               "",  1, 1,0},
        {"Aps_PrinterRename", "Handle", "Printer name", "", "", "", "", "",
                                                              "",  2, 0, 0},
        {"Aps_PrinterSetMaxJobSize", "Handle", "Max Job Size", "", "", "", 
                                                       "", "","",  2, 0, 0},
        {"Aps_PrinterGetMaxJobSize", "Handle", "", "", "", "Max Job Size", 
                                                       "", "","",  1, 1, 0},
        {"Aps_PrinterSetConfigFlags", "Handle", "FlagsToSet", "FlagsToReset",
                                                "", "", "", "","",  3, 0, 0},
        {"Aps_PrinterGetConfigFlags", "Handle", "", "", "", "Config Flags", 
                                                        "", "","",  1, 1, 0},
        {"Aps_PrinterGetConnectInfo", "Handle", "Connecion Type", "", "", 
                         "location", "", "","",  2, 1, 0},
        {"Aps_PrinterSetConnectInfo", "Handle", "Connecion Type", 
                       "location", "", "", "", "","",  3, 0, 0},
        {"Basic Printing","Printer Handle", "Filename", "Format", 
                                      "Settings", "Job", "", "", "", 0, 0, 0}
};
