/*
 *  Copyright (c) 2000 Matthias Elter <elter@kde.org>
 *  based on keyes (C) 1999 by Jerome Tollet <tollet@magic.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 */

#include <qpainter.h>
#include <qxembed.h>
#include <qpopupmenu.h>

#include <klocale.h>
#include <kglobal.h>
#include <kapp.h>

#include <math.h>

#include "eyes.h"


#define min(a,b) ((a) < (b) ? (a) : (b))

extern "C"
{
  KPanelApplet* init(QWidget *parent, const QString& configFile)
  {
	KGlobal::locale()->insertCatalogue("keyesapplet");
    EyesApplet *applet = new EyesApplet(configFile, KPanelApplet::Normal, 0,
                                        parent, "keyesapplet");
    return applet;
  }
}


EyesApplet::EyesApplet(const QString& configFile, Type t, int actions,
                       QWidget *parent, const char *name)
  : KPanelApplet( configFile, t, actions, parent, name )
{
  display = kapp->getDisplay();
  root = RootWindow(display,DefaultScreen(display));

  startTimer(10);
}

void EyesApplet::paintEvent(QPaintEvent*)
{
  oldPoint1 = QPoint(-1, -1 );
  oldPoint2 = QPoint( -1, -1 );
  timerEvent(0);
}

void EyesApplet::timerEvent(QTimerEvent*)
{
  QPoint p,mouse,vect;
  double cos_alpha,sin_alpha;
  int WinX, WinY;
  int XCoord,YCoord;
  
  XQueryPointer (display, root, &RootIDRet, &ChildIDRet, &XCoord,&YCoord, &WinX, &WinY, &StateMask);
  mouse = mapFromGlobal(QPoint(XCoord,YCoord));
  int tmp=min(height(),width())/6;

  //Left eye
  vect.setX(mouse.x()-width()/4);
  vect.setY(mouse.y()-height()/2);
  
  cos_alpha=vect.x()/sqrt(vect.x()*vect.x()+vect.y()*vect.y());
  sin_alpha=vect.y()/sqrt(vect.x()*vect.x()+vect.y()*vect.y());
  
  if(vect.x()*vect.x() + vect.y()*vect.y() > (width()/4-tmp)*(width()/4-tmp)*
	 cos_alpha*cos_alpha+(height()/2-tmp)*(height()/2-tmp)*sin_alpha*sin_alpha)
	{
	  p.setX((width()/4-tmp)*cos_alpha+width()/4);
	  p.setY((height()/2-tmp)*sin_alpha+height()/2);	
	} 
  else
	p=mouse;
  
  if( (p.x() != oldPoint1.x()) || (p.y() != oldPoint1.y())) {
	QPainter paint(this);
	paint.setPen(white);
	paint.setBrush(white);
	paint.drawEllipse(oldPoint1.x()-sizeEye/2,oldPoint1.y()-sizeEye/2,sizeEye,sizeEye);
	paint.setPen(QPen(black));
	paint.drawEllipse(0,0,width()/2,height());
	paint.setBrush(QBrush(black));
	sizeEye=min(height(),width())/6;
	paint.drawEllipse(p.x()-sizeEye/2,p.y()-sizeEye/2,sizeEye,sizeEye);	
	oldPoint1 = p;
  }
  
  //Right eye
  vect.setX(mouse.x()-3*width()/4);
  vect.setY(mouse.y()-height()/2);
  
  cos_alpha=vect.x()/sqrt(vect.x()*vect.x()+vect.y()*vect.y());
  sin_alpha=vect.y()/sqrt(vect.x()*vect.x()+vect.y()*vect.y());
  
  if(vect.x()*vect.x() + vect.y()*vect.y() > (width()/4-tmp)*(width()/4-tmp)
	 *cos_alpha*cos_alpha+(height()/2-tmp)*(height()/2-tmp)*sin_alpha*sin_alpha)
	{
	  p.setX((width()/4-tmp)*cos_alpha+3*width()/4);
	  p.setY((height()/2-tmp)*sin_alpha+height()/2);	
	}
  else
	p=mouse;
    
  if( (p.x() != oldPoint2.x()) || (p.y() != oldPoint2.y())) {
	QPainter paint(this);
	paint.setPen(white);
	paint.setBrush(white);
	paint.drawEllipse(oldPoint2.x()-sizeEye/2,oldPoint2.y()-sizeEye/2,sizeEye,sizeEye);
	paint.setPen(QPen(black));
	paint.drawEllipse(width()/2,0,width()/2,height());
	paint.setBrush(QBrush(black));
	sizeEye=min(height(),width())/6;
	paint.drawEllipse(p.x()-sizeEye/2,p.y()-sizeEye/2,sizeEye,sizeEye);	
	oldPoint2 = p;
  }  
}

int EyesApplet::widthForHeight(int h)
{
  // I want to have a quadratic shape.
  return h;
}
int EyesApplet::heightForWidth(int w)
{
  // I want to have a quadratic shape.
  return w;
}

void EyesApplet::resizeEvent( QResizeEvent* )
{
  sizeEye=min(height(),width())/6;
  oldPoint1.setX(width()/4);
  oldPoint1.setY(height()/2);
  oldPoint2.setX(3*width()/4);
  oldPoint2.setY(height()/2);
}

#include "eyes.moc"
