/* -*- C++ -*-
   This file implements the test for the kabapi. You have to "make check"
   to build it.

   the KDE addressbook

   $ Author: Mirko Boehm $
   $ Copyright: (C) 1996-2000, Mirko Boehm $
   $ Contact: mirko@kde.org
         http://www.kde.org $
   $ License: GPL with the following explicit clarification:
         This code may be linked against any version of the Qt toolkit
         from Troll Tech, Norway. $

   $Revision: 1.11 $
*/

#include <qimage.h>
#include <kabapi.h>
#include <iostream.h>
#include <kapp.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kcmdlineargs.h>

static const char *description = 
	I18N_NOOP("Test program");

static const char *version = "v0.0.1";

int main(int argc, char** argv)
{
  // ############################################################################
  KCmdLineArgs::init(argc, argv, "kabapi_test", description, version);

  KApplication app;

  KabAPI api;
  // ----- <test>:
  if(api.init()!=AddressBook::NoError)
    {
      KMessageBox::information
	(0, i18n("Error initializing addressbook API."),
	 i18n("Error"));
      return -1;
    }
  if(api.exec())
    {
      QString name;
      QString text;
      AddressBook::Entry entry;
      KabKey key;
      // -----
      debug("kabapi_test: test accepted.");
      switch(api.getEntry(entry, key))
	{
	case AddressBook::NoError:
	  api.addressbook()->literalName(entry, name, true, false);
	  text="KabAPI test: entry is "+name.utf8();
	  break;
	case AddressBook::NoEntry:
	  text="KabAPI test: no entries.";
	  break;
	default:
	  text="Internal error.";
	}
      KMessageBox::information(0, text, "Selection");
    } else {
      debug("kabapi_test: test rejected.");
    }
  // ----- </test>
  return 0;
  // ############################################################################
}


