/* -*- C++ -*-
   This file implements kabs toplevel widget..

   the KDE addressbook

   $ Author: Mirko Boehm $
   $ Copyright: (C) 1996-2000, Mirko Boehm $
   $ Contact: mirko@kde.org
         http://www.kde.org $
   $ License: GPL with the following explicit clarification:
         This code may be linked against any version of the Qt toolkit
         from Troll Tech, Norway. $

   $Revision: 1.27 $	
*/

#ifndef KAB_TOPLEVEL_WIDGET_H
#define KAB_TOPLEVEL_WIDGET_H

#include <kmainwindow.h>
#include <kabapi.h>

class KABBasicLook;
class KDataNavigator;
class QPopupMenu;
class QTimer;
class QStringList;
class Section;

class TopLevelWidget : public KMainWindow
{
  Q_OBJECT
public:
  /** The indices of the statusbar parts. */
  enum StatusbarIndex { Text=1, /**< The status text. */
			Number /**< The number of entries. */
  };
  /** This descriptors are used to create the view. */
  enum View { NoView=0,
	      BusinessCard,
	      Editing,
	      NoOfViews // not a real view
  };
  enum ActionIDs { NoAction=0,
		   NewEntry,
		   EditEntry,
		   DeleteEntry,
		   FirstEntry,
		   PrevEntry,
		   Entries,
		   NextEntry,
		   LastEntry
  };
  /** The constructor. */
  TopLevelWidget();
  /** The destrcutor. */
  ~TopLevelWidget();
protected:
  /** Construct the menubar. */
  void makeMenu();
  /** Construct the toolbar. */
  void makeToolbar();
  /** Construct the statusbar. */
  void makeStatusbar();
  /** Create the interface to the address database. */
  bool initializeInterface();
  /** Handle window closing correctly. */
  bool queryClose();
  /** Create the view. This method reads the latest view
      chosen by the user and restores it if no view is given.
  */
  void createView(View=NoView, bool recreate=false);
  /**A frame that contains the view widgets. This is needed as
     KTMainWindow seems to be picky about changing the main window of
     an application. */
  QFrame *viewFrame;
  /** The main widget. There are different child classes of
   *  KABBasicLook. */
  KABBasicLook *view;
  /** Stores the currently selected view. */
  View currentView;
  /** The interface to the AddressBook object. */
  KabAPI *api;
  /** A pointer to a key storing the entry currently displayed.
   *  This property is set by the entrySelected method.
   *  @see entrySelected
   */
  KabKey *current;
  /** Some flags to adapt the GUI to. */
  bool hasEmailAddresses, hasURLs;
  /** The pointer to the file menu. */
  QPopupMenu *file;
  /** The pointer to the import menu. */
  QPopupMenu *import;
  /** The pointer to the edit menu. */
  QPopupMenu *edit;
  /** The pointer to the view menu. */
  QPopupMenu *menuview;
  /** The IDs of the view status entries. */
  int idViewBC, idViewEdit;
  /** The datanavigator widget. Although it is child of the toolbar,
   *  the pointer to the datanavigator is stored here to be able to
   *  update its contents. */
  KDataNavigator *nav;
  /** Used to reset the status bar. */
  QTimer *timer;
  /** The list containing the status messages to display. */
  QStringList *messages;
  /** If true, the entry needs to be saved before showing another
      one. */
  bool modified;
  /** Signals that the "Quit" button has been selected. */
  bool closingdown;
  /** Edit the current entry. */
  bool editCurrentEntry();
  /** Open the edit dialog to modify the entry. */
  bool editEntry(AddressBook::Entry& entry);
  /** Remove this entry. If quiet is true, the entry is removed
      silently even if query-on-delete is set. Use it for deleting
      temporaries. Careful! */
  bool removeCurrentEntry(bool quiet=false);
  // ----- protected members:
  //       the strange notation may be obsolete when using actions
  /** The id of the edit and remove menu items. */
  int idEditAdd, idEditEdit, idEditRemove; 
  /** The id of the mail and browse menu items. */
  int idEditMail, idEditBrowse;
  /** The id of the save menu item. */
  int idFileSave;
public slots:
  /** An entry has been selected. */
  void entrySelected(int);
  /** The entries map has changed. Possibly the database, too...*/
  void entriesChanged();
  // The file menu:
  /** Create a new address database. Triggered from the menu. */
  void createNew();
  /** Load the standard database. This is the predefined user database
   *  created on the first start of the program. Note that the user might
   *  configure this filename!. Triggered from the menu. */
  void loadDefaultDatabase();
  /** Load a database file. With kab2, the filename is no more fixed.
   *  Triggered from the menu. */
  void loadDatabaseFile();
  /** Save the database. */
  void save();
  /** Import kab 1 addressbook. This is triggered from the menu. */
  void importKab1Addressbook();
  /** Set the status bar text. */
  void setStatus(const QString&);
  /** Erase it after some time. */
  void statusbarTimeOut();
  /** The business card view has been selected. */
  void selectViewBC();
  /** The editing view has been selected. */
  void selectViewEdit();
  /** Catch toolbar actions. */
  void action(int);
  /** Add an entry. */
  void add();
  /** Edit an entry. */
  void editEntrySlot();
  /** Remove an entry. */
  void remove();
  /** Send an email. Calls mail(const QString& url). Just for convenience. */
  void mail();
  /** Send an email. */
  void mail(const QString& url);
  /** Browse the homepage. Calls browse(const QString& url). Just for convenience. */
  void browse();
  /** Browse the homepage. */
  void browse(const QString& url);
  /** Enable all messages disabled by the "do not show again" button. */
  void enableAllMessages();
  /** Configure settings local to the file. User field names, for example. */
  void configureFile();
  /** Configure settings for the application. */
  void configureKab();
  /** The currently displayed entry has been changed by the user. We
      will store this in a boolean value, and (according to a
      configuration setting) ask the user to save her changes before
      displaying another entry. */
  void entryChangedSlot();
  /** Catch the save me signal emitted by the views. Save and update
      the actions. */ 
  void saveMeSlot();
  /** Quit the application. */
  void quit();
  /** About-kab-slot. Overloaded from KTMainWindow. */
  void showAboutApplication(void);
  /** Enable or disable menu items etc. */
  void enableButtons();
  /** Load configuration. On startup, or if it changed. */
  void loadConfiguration();
signals:
  /** Called after changes in the database that the AddressBook object
   *  does not recognize.
   */
  void databaseChanged();
protected:
  // Everything following here is read from the global configuration
  // and updated if it changes.
  bool showAssembledNameInWindowTitle;
  bool rememberLastView;
  bool rememberLastEntry;
  bool createBackupOnStartup;
};

#endif // KAB_TOPLEVEL_WIDGET_H
