/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qfile.h>
#include <qtextstream.h>

#include "driveinfo.h"


DriveInfo::DriveInfo(const QString& deviceid, drivetype drvtype) : _deviceid(deviceid)
{
  QFile    procpart("/proc/partitions");
  ushort   major, minor;
  ulong    blocks, total, used, avail;
  QString  devid, line, mountpoint;
  char     dev[8];
  
  _partlist.setAutoDelete(true);
  _partlist.clear();
  
  if (drvtype == DriveCDROM)
  {
    mountpoint = readSizes(deviceid, &total, &used, &avail);                          
    _blocks    = total;
    
    return;
  }
  
  if (procpart.exists())
  {
    if (procpart.open(IO_ReadOnly))
    {
      QTextStream  s(&procpart);
      
      s.readLine();	// Drop header
      s.readLine();
      
      while (!s.eof())
      {
        if ((line = s.readLine()).isEmpty()) break;

        sscanf(line.local8Bit(), "%hu %hu %lu %s", &major, &minor, &blocks, dev);

        devid = dev;
        
	if (devid == deviceid)
        {
          _major  = major;
          _minor  = minor;
          _blocks = blocks;
 
          while (!s.eof())
          {
            if ((line = s.readLine()).isEmpty()) break;
            
            sscanf(line.local8Bit(), "%hu %hu %lu %s", &major, &minor, &blocks, dev);
            devid = dev;
            
            if (devid.left(3) != deviceid) break;
            
            if (minor & 0x3f)
            {            
              mountpoint = readSizes(devid, &total, &used, &avail);                          
              _partlist.append(new PartitionInfo(devid, major, minor, mountpoint, blocks, total, used, avail));
            }
          }
 
          break;
        }
      }
      
      procpart.close();
    }
  }
}


QString  DriveInfo::readSizes(const QString& partid, ulong *sizetotal, ulong *sizeused, ulong *sizeavail)
{
  FILE     *fhd;
  char     mountp[64] = "";
  QString  line;
      
  *sizetotal = *sizeused = *sizeavail = 0;    
      
  if ((fhd = popen("df", "r")))
  {
    QTextStream  s(fhd, IO_ReadOnly);
    
    s.readLine();	// Drop header
    
    while (!s.eof())
    {
      if ((line = s.readLine()).isEmpty()) break;

      if (line.mid(5, partid.length()) == partid)
      {
        // local8Bit() 'cause it's read with locale
        sscanf(line.local8Bit(), "%*s %lu %lu %lu %*s %s", sizetotal, sizeused, sizeavail, mountp);       
        break;
      }
    }
    
    pclose(fhd);
  }
  
  return QFile::decodeName(mountp);
}

