//////////////////////////////////////////////////////////////
//      $Id: debInterface.h,v 1.9 2000/07/14 15:58:15 toivo Exp $ 
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef DEB_IFACE_H
#define DEB_IFACE_H

#include "../config.h"

#include <qlist.h>
#include <qdir.h> 
#include <qfile.h> 
#include <qfileinf.h> 
#include <qtextstream.h>
#include <qstringlist.h> 

#include <kprocess.h>

#include "procbuf.h"
#include "pkgInterface.h"

class packageInfo;
class updateLoc;
class cacheObj;

class DEB: public pkgInterface
{
  Q_OBJECT

public:
  DEB();
  ~DEB();
  
  bool isType(char *buf, const QString &fname);
  void listPackages(QList<packageInfo> *pki);
  param *initinstallOptions();
  param *inituninstallOptions();
  packageInfo *getPackageInfo(char mode, const QString &name, const QString &version);
  QStringList *getFileList(packageInfo *p);

  void listInstalledPackages(QList<packageInfo> *pki);

  QString FindFile(const QString &name);
  bool parseName(QString name, QString *n, QString *v);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

private:
  packageInfo *getIPackageInfo(const QString &name);
  packageInfo *getUPackageInfo(const QString &name);

  packageInfo* collectInfo(QStringList &inp);
  void listPackList(QList<packageInfo> *pki,
		    const QString &fname, cacheObj *cp);
  int dpkgChange(int del);

  int doUninstall(int installFlags, QString packs);
  int doInstall(int installFlags, QString packs);

  void distPackages(QList<packageInfo> *pki, cacheObj *cp);
  void listUnIPackages(QList<packageInfo> *pki, LcacheObj *pCache);
};

#endif



