//////////////////////////////////////////////////////////////         
//      $Id: pkguninstallDialog.cpp,v 1.13 2000/09/04 22:27:03 faure Exp $ 
//
// Author: Toivo Pedaste
//
#include "../config.h"
#include "pkguninstallDialog.h"
#include "pkgInterface.h"
#include "kpackage.h"
#include <klocale.h>
#include <kglobal.h>
#include <kglobalsettings.h>

pkguninstallDialog::pkguninstallDialog(param *pars, QWidget *parent)
  : QDialog(parent, 0, TRUE)
{
  int i;
  resize(300,200);

  // Create the widgets
  uninstallButton = new QPushButton(i18n("Uninstall"), this);
  cancelButton = new QPushButton(i18n("Cancel"), this);

  // count number of buttons
  bnumber = 0;
  for (i = 0; pars[i].name != 0; i++) {
    bnumber = i;
  }
  bnumber = i;

  Boxs = new QCheckBox *[bnumber];
  for (i = 0; i < bnumber; i++) {
    Boxs[i] = new QCheckBox(pars[i].name, this);
    Boxs[i]->setChecked(pars[i].init);
  }

  label = new QLabel("",this);
  label->setMargin(1);
  QFont f( KGlobalSettings::generalFont());
  f.setBold(true);
  f.setPointSize(f.pointSize()+6);
  label->setFont(f);
  label->setAutoResize(TRUE);
  label->update();

  // Connections
  connect(uninstallButton,SIGNAL(clicked()), SLOT(uninstallClicked()));
  connect(cancelButton, SIGNAL(clicked()), SLOT(cancelClicked()));

  // Create the layout managers
  QBoxLayout *buttons;
  layout = new QBoxLayout(this, QBoxLayout::TopToBottom,5,0);
  buttons = new QBoxLayout(QBoxLayout::LeftToRight);


  // Setup layout
  layout->addWidget(label,2);
  layout->addStretch(1);
  for (i = 0; i < bnumber; i++) {
    layout->addWidget(Boxs[i],1);
  }
  layout->addStretch(1);
  layout->addLayout(buttons);

  buttons->addWidget(uninstallButton,2);
  buttons->addStretch(2);
  buttons->addWidget(cancelButton, 2);

  layout->activate();
}

pkguninstallDialog::~pkguninstallDialog()
{
  int i;
  for (i = 0; i < bnumber; i++) {
    delete(Boxs[i]);
  }
  delete uninstallButton;
  delete cancelButton;
  delete label;
  delete layout;
}

void pkguninstallDialog::setup(packageInfo *p)
{
  QString s;

  package = p;
  s = i18n("Uninstall: %1\n")
  	  .arg(package->getProperty("name"));
  label->setText(s);
}

void pkguninstallDialog::uninstallClicked()
{
  int i, r, uninstallFlags=0;

  for (i = 0; i < bnumber; i++) {
    uninstallFlags |= (Boxs[i]->isChecked()) << i;
  }	

  r = package->interface->uninstall(uninstallFlags,package);

  if (!r)
    accept();
}

void pkguninstallDialog::cancelClicked()
{
  reject();
}

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
pkguninstallDialogMult::pkguninstallDialogMult(param *pars, QWidget *parent)
  : pkguninstallDialog(pars, parent)
{
}

pkguninstallDialogMult::~pkguninstallDialogMult()
{
  notModified = TRUE;
}

void pkguninstallDialogMult::setup(QList<packageInfo> *pl, QString type)
{
  QString s;

  packList = pl;
  s = i18n("Uninstall: %1 %2 Packages\n").arg(packList->count()).arg(type);
  label->setText(s);
}

void pkguninstallDialogMult::uninstallClicked()
{
  int i, r, uninstallFlags=0;

  notModified = FALSE;

  for (i = 0; i < bnumber; i++) {
    uninstallFlags |= (Boxs[i]->isChecked()) << i;
  }	

  r = packList->first()->interface->uninstall(uninstallFlags,packList);

  if (!r)
    accept();
}

void pkguninstallDialogMult::cancelClicked()
{
  if (notModified)
    reject();
  else 
    accept();
}
