//////////////////////////////////////////////////////////////         
//      $Id: procbuf.cpp,v 1.15 2000/09/13 14:42:14 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include "../config.h"
#include "procbuf.h"
#include <kprocess.h>
#include "kpackage.h"
#include <klocale.h>

Modal::Modal(QString msg, QWidget *parent, const char * name )
  : QDialog( parent, name, TRUE )
{
  QLabel *line1 = new QLabel(msg,this);
  line1->setAlignment(AlignCenter);
  line1->setAutoResize(true);

 }

void Modal::terminate()
{
  done(0);
}

procbuf::procbuf()
{
  m = NULL;
}

procbuf::~procbuf()
{
}

void procbuf::setup(QString cmd)
{
  buf.truncate(0);
  proc = new KProcess();
  connect(proc, SIGNAL( receivedStdout(KProcess *, char *, int)), 
			this, SLOT(slotReadInfo(KProcess *, char *, int)));
  connect(proc, SIGNAL( receivedStderr(KProcess *, char *, int)), 
			this, SLOT(slotReadInfo(KProcess *, char *, int)));
  connect(proc, SIGNAL( processExited(KProcess *)), 
			this, SLOT(slotExited(KProcess *)));
  proc->clearArguments();
  *proc << cmd;
  command = cmd;
}

void procbuf::slotReadInfo(KProcess *, char *buffer, int buflen)
{
   char last;

   last = buffer[buflen - 1];
   buffer[buflen - 1] = 0;
   buf += buffer;
   buf += last;
}

void procbuf::slotExited(KProcess *)
{
  if (m) {
    m->terminate();
  }
}

int procbuf::start (const QString & msg, bool errorDlg )
{
  if (!proc->start(!msg.isNull() ? KProcess::NotifyOnExit : KProcess::Block,
		   KProcess::AllOutput)) {
    if (errorDlg) {
      KpMsgE(i18n("Kprocess Failure"),TRUE);
    }
    return 0;
  };

  if (!msg.isEmpty()) {
    m = new Modal(msg,kpkg, "wait");
    m->exec();
    delete m;
    m = 0;
  }

  kdDebug() << command 
	    << " dialog=" << errorDlg 
	    << " normal=" << proc->normalExit()
	    << " exit=" << proc->exitStatus() << endl;

  if (!proc->normalExit() || proc->exitStatus()) {
    if (errorDlg) {
      KpMsg("Error",i18n("Kprocess error:%1").arg(buf), TRUE);
    }
    delete proc; proc = 0;
    return 0;
  }

  delete proc;  proc = 0;
  return 1;
}











