// (c) 2000 Peter Putzer

#ifndef PREFERENCES_DIALOG_H
#define PREFERENCES_DIALOG_H

#include <qstring.h>

#include <kdualcolorbtn.h>
#include <kdialogbase.h>

class KLineEdit;
class KSVConfig;
class QPushButton;

class KSVPreferences : public KDialogBase
{
  Q_OBJECT

public:
  static KSVPreferences* self ();
  virtual ~KSVPreferences ();

  inline QColor newNormal () const { return mNewColors->foreground(); }
  inline QColor newSelected () const { return mNewColors->background(); }
  inline QColor changedNormal () const { return mChangedColors->foreground(); }
  inline QColor changedSelected () const { return mChangedColors->background(); }

  QString runlevelPath () const;
  QString scriptPath () const;

signals:
  void updateColors ();
  void updateServicesPath ();
  void updateRunlevelsPath ();

protected slots:
  virtual void slotApply ();
  virtual void slotCancel ();
  virtual void slotOk ();

private slots:
  void scriptDir();
  void runlevelDir();
  void reReadConfig();
  void showAllMessages ();

private:
  friend class KSVTopLevel;

  KSVPreferences (QWidget* parent);
  void setConfig ();
  bool checkPaths();

  KSVConfig* mConfig;

  KDualColorButton* mNewColors;
  KDualColorButton* mChangedColors;

  KLineEdit* mScriptPath;
  KLineEdit* mRunlevelsPath;

  QPushButton* mBrowseScripts;
  QPushButton* mBrowseRunlevels;
};


#endif // PREFERENCES_DIALOG_H
