//////////////////////////////////////////////////////////////
//      $Id: kissInterface.h,v 1.6 1999/07/27 15:39:17 toivo Exp $ 
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef KISS_IFACE_H
#define KISS_IFACE_H

#include "../config.h"

#include <qlist.h>
#include <qstringlist.h>
#include <kprocess.h>

#include "procbuf.h"
#include "pkgInterface.h"

class packageInfo;
class updateLoc;
class cacheObj;

class KISS: public pkgInterface
{
  Q_OBJECT

public:
  KISS();
  ~KISS();
  
  bool isType(char *buf, const QString &fname);
  param *initinstallOptions();
  param *inituninstallOptions();
  packageInfo *getPackageInfo(char mode, const QString &name, const QString &version);
  QStringList *getFileList(packageInfo *p);

  QString FindFile(const QString &name);
  bool parseName(QString name, QString *n, QString *v);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

private:
  packageInfo* collectInfo(const char *inp);
  void listInstalledPackages(QList<packageInfo> *pki);
 
  int install(int installFlags, QList<packageInfo> *plist);
  int uninstall(int uninstallFlags, QList<packageInfo> *plist);

  int doUninstall(int installFlags, QString packs);
  int doInstall(int installFlags, QString packs);

};

#endif



