//////////////////////////////////////////////////////////////         
//      $Id: pkgInterface.cpp,v 1.37 2000/08/09 15:17:30 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
 
#include "kpackage.h"
#include "pkgInterface.h"
#include "options.h"
#include "cache.h"
#include "updateLoc.h"
#include "kio.h"

extern Params *params;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
pkgInterface::pkgInterface() : QObject(), new_pict(), updated_pict()
{
  packageLoc = 0;

  folder = SmallIcon("folder");
  markInst = UserIcon("tick");
  markUnInst = UserIcon("noball");
  bad_pict = UserIcon("dbad");
}

//////////////////////////////////////////////////////////////////////////////
pkgInterface::~pkgInterface()
{
  if (locatedialog)
    delete locatedialog;
  if (packageLoc)
    delete packageLoc;
}

//////////////////////////////////////////////////////////////////////////////
QStringList *pkgInterface::depends(const QString &, int ) {return 0;}

int pkgInterface::doUninstall(int, QString) {return 0;}
int pkgInterface::doInstall(int, QString) {return 0;}

////////////////////////////////////////////////////////////////////////////

void pkgInterface::listPackages(QList<packageInfo> *pki)
{ 
  QString s;
  cacheObj *cp;

  listInstalledPackages(pki);
  if (packageLoc) {
    for (cp = packageLoc->first(); cp != 0; cp = packageLoc->next()) {
      s = getDir(cp); 
      if (s != "") {
	listDir(pki, s, cp->location, cp->subdirs);
      }
    }
  }
}

void pkgInterface::smerge(packageInfo *)
{ }

void pkgInterface::listDir(QList<packageInfo> *pki, QString fname, QString dir, bool subdirs)
{
  QString name, size, rfile;
  packageInfo *p;

  QString sline( queryMsg + fname );
  kpackage->setStatus(sline);

  QDir d(fname,packagePattern);

  if (subdirs)
    d.setMatchAllDirs( TRUE );        // list contains subdirs
  else
    d.setMatchAllDirs( FALSE );       // list contains no subdirs

  if (d.exists()) {
    if ( d.isReadable() ) {
      QString pn;
      const QFileInfoList *list = d.entryInfoList();
      QFileInfoListIterator it( *list );      // create list iterator
      QFileInfo *fi;                          // pointer for traversing

      while ( (fi=it.current()) ) {           // for each entry...
	if ( fi->isDir() ) {
	  // entry is a subdir
	  if ( fi->fileName() != (const QString &)"." &&
	       fi->fileName() != (const QString &)".." )
	    {
	      // not current dir and not parent dir
	      // -> recursive call:
	      listDir( pki, dir + "/" + fi->fileName(), dir + "/" + fi->fileName(), subdirs );
	    } else {
	      // current dir or parent dir
	      // -> notihng to do
	      ;
	    }
	} else {
	  // entry is a file
	  if (params->PkgRead) {
	    rfile = dir + "/";
	    rfile += fi->fileName();
	    p = getPackageInfo('u',rfile, 0);
	    if (p) {
	      p->info->insert("filename", new QString(fi->fileName()));
	      p->info->insert("base", new QString(dir));
	    }
	  } else {
	    p = collectDir(fi->fileName(),pn.setNum(fi->size()),dir);
	  }
	  if (p) {
	    smerge(p);
	    if (!p->update(pki, typeID, FALSE))
	      delete p;
	  }
	}
	++it;                               // goto next list element
      }
    } else {
      // directory is not readable
      kdDebug() << i18n("WARNING: directory '%1' not readable (will be ignored) !\n").arg(d.absPath() ) << endl;
    } 
  } else {
      QFile f(fname);
      if ( f.open(IO_ReadOnly) ) {  
	QTextStream t( &f );
	QString name;
	while ( !t.eof() ) {
	  name = t.readLine();
	  if (!t.eof() ) {
	    size = t.readLine();
	  } else
	    size = "";
	  packageInfo *p = collectDir(name,size,dir);
	  if (p) {
	    smerge(p);
	    if (!p->update(pki, typeID, FALSE))
	      delete p;
	  }
	}
	f.close();
      }
    }
  }

packageInfo *pkgInterface::collectDir(QString name, QString size, QString dir) 
{
  QString n,v;

  if (parseName(name, &n, &v)) {
    QDict<QString> *a = new QDict<QString>;
    a->setAutoDelete(TRUE);

    a->insert("group", new QString("NEW"));
    a->insert("name", new QString(n));
    a->insert("version", new QString(v));
    a->insert("file-size", new QString(size));
    a->insert("filename", new QString(name));
    a->insert("base", new QString(dir));

    packageInfo *i = new packageInfo(a,this);
    i->packageState = packageInfo::AVAILABLE;
    //    i->packageState = packageInfo::NEW;
    return i;
    } 
  return 0;
}

QString pkgInterface::getPackList(cacheObj *cp) 
{
  QString tmpf;
  int res;
  QString url = cp->location;

  if ((res = cacheObj::newDCache(url, cp->cacheFile, tmpf))) {
    if (res < 0)
      return 0;

    unlink(QFile::encodeName(tmpf));
    if (kpkg)
      kpackage->setStatus(i18n("Starting Kio"));

    Kio kio;
    if (kio.download(url, tmpf)) {
      if (kpkg)
	kpackage->setStatus(i18n("Kio finished"));
      QFileInfo f(tmpf);
      if (!(f.exists() && f.size() > 0)) {
	unlink(QFile::encodeName(tmpf));
	return "";
      } else {
	return tmpf;
      }
    } else {
      if (kpkg)
	kpackage->setStatus(i18n("Kio failed"));
      return "";
    }
  } else {
    return tmpf;
  }
}

QString pkgInterface::getDir(cacheObj *cp) {
  QString string = "";
  int res;
  QString tmpDir;

  QString url = cp->location;

  if ((res = cacheObj::newDCache(url, cp->cacheFile, tmpDir))) {
    if (res < 0)
      return string;

    Kiod kiod;
    if (kiod.listDir(url,tmpDir)) {
      return tmpDir;
    } else {
      KpMsgE(i18n("Cann't read directory %1").arg(url),FALSE);
      unlink(tmpDir.ascii());
      return string;
    }
  } else {
    return tmpDir;
  }
}


//////////////////////////////////////////////////////////////////////////////

QString  pkgInterface::provMap(QString p)
{
  //  kdDebug() << "provMap=>" << p << endl;
  return p;
}

//////////////////////////////////////////////////////////////////////////////
QStringList *pkgInterface::verify(packageInfo *, const QStringList &files)
{
  int  p = 0;
  uint c = 0;
  QStringList *errorlist = new QStringList;
  QDir d;

  uint step = (files.count() / 100) + 1;

  kpackage->setStatus(i18n("Verifying"));
  kpackage->setPercent(0);

  for( QStringList::ConstIterator it = files.begin();
       it != files.end();
       it++)
    {
    // Update the status progress
    c++;
    if(c > step) {
      c=0; p++;
      kpackage->setPercent(p);
    }

    if (!d.exists(*it)) {
      errorlist->append(*it);
    }	
  }

  kpackage->setPercent(100);
  return errorlist;
}

//////////////////////////////////////////////////////////////////////////////
int pkgInterface::uninstall(int uninstallFlags, packageInfo *p)
{
  QString packs( p->getProperty("name"));

  return doUninstall(uninstallFlags, packs);
}

//////////////////////////////////////////////////////////////////////////////
int pkgInterface::uninstall(int uninstallFlags, QList<packageInfo> *p)
{
  QString packs = "";
  packageInfo *i;

  for (i = p->first(); i!= 0; i = p->next())  {
    packs += i->getProperty("name");
    packs += " ";
  }
  return doUninstall( uninstallFlags, packs);
}
//////////////////////////////////////////////////////////////////////////////

int pkgInterface::install(int installFlags, packageInfo *p)
{
  QString fname = p->fetchFilename();

  return doInstall(installFlags, fname);
}

//////////////////////////////////////////////////////////////////////////////
int pkgInterface::install(int installFlags, QList<packageInfo> *p)
{
  QString packs = "";
  packageInfo *i;

  for (i = p->first(); i!= 0; i = p->next())  {
    QString fname = i->fetchFilename();
    if (fname != "") {
      packs += fname;
      packs += " ";
    }
  }
  return doInstall(installFlags, packs);
}

