#include <kapp.h>

#include "kio.h"

Kio::Kio()
{
}

bool Kio::download(const KURL & from, const QString & to)
{
    KIO::Job *iojob = KIO::file_copy(from, to);
    connect( iojob, SIGNAL( result(KIO::Job*) ),
	     SLOT( slotIOJobFinished( KIO::Job* )));

    // missing modal widget hack here.
    // I'd recommend using KIO::NetAccess instead (David).
    kapp->enter_loop();
    return worked;
}

void Kio::slotIOJobFinished( KIO::Job * job)
{
    worked = (job->error() == 0);
    kapp->exit_loop();
}

Kiod::Kiod()
{
}

bool Kiod::listDir(QString url, QString fname)
{
  file = new QFile(fname);
  if (file->open(IO_WriteOnly)) {
    fileT = new QTextStream(file);
    KIO::ListJob *job = KIO::listDir( url );

    QObject::connect( job, SIGNAL( entries( KIO::Job*, const KIO::UDSEntryList& ) ),
		      SLOT( slotListEntries( KIO::Job*, const KIO::UDSEntryList& ) ) );
    QObject::connect( job, SIGNAL( result( KIO::Job * ) ),
		      SLOT( slotFinished( KIO::Job* ) ) );

    kapp->enter_loop();

    file->close();
    if (worked)
      return TRUE;
    else
      return FALSE;
  } else
    return FALSE;
}

void Kiod::slotListEntries( KIO::Job *, const KIO::UDSEntryList& entries )
{
  long size = 0;
  QString text;

  KIO::UDSEntryList::ConstIterator entryIt = entries.begin();
  KIO::UDSEntryList::ConstIterator entryEnd = entries.end();

  for (; entryIt != entryEnd; ++entryIt) {
      for (KIO::UDSEntry::ConstIterator it = (*entryIt).begin();
	   it != (*entryIt).end(); it++ ) {
	  if ( (*it).m_uds == KIO::UDS_SIZE )
	      size = (*it).m_long;
	  else if ( (*it).m_uds == KIO::UDS_NAME )
	      text = (*it).m_str;
      }
      *fileT << text << "\n" << size << "\n";
  }
}

void Kiod::slotFinished( KIO::Job *job )
{
    worked = (job->error() == 0);
    kapp->exit_loop();
}
