///////////////////////////////////////////////////////////////////////////////
// $Id: main.cpp,v 1.19 2000/09/01 20:19:46 waba Exp $	
// File  : main.cpp
// Author: Damyan Pepper
// Author: Toivo Pedaste
//
// This is the entry point to the program
///////////////////////////////////////////////////////////////////////////////
#include "../config.h"
#include "kpackage.h"

#include <qfile.h>

#include <kapp.h>
#include <kglobal.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <options.h>

#include <kaboutdata.h>

#include "debInterface.h"
#include "kissInterface.h"
#include "slackInterface.h"
#include "fbsdInterface.h"
#ifdef HAVE_RPM
#include "rpmInterface.h"
#endif


static const char *description = 
	I18N_NOOP("KDE Package installer");

static KCmdLineOptions options[] =
{
   { "+[Package]", I18N_NOOP("Package to install"), 0 },
   { 0, 0, 0 }
};

// Keep a global pointer to ksetup
KPKG *kpkg;
KPACKAGE *kpackage;

Params *params;

const int kpinterfaceN = 5;

pkgInterface *kpinterface[kpinterfaceN];
 
int main(int argc, char **argv)
{
  KAboutData aboutData( "kpackage", I18N_NOOP("KPackage"), 
			  VERSION, description, KAboutData::License_GPL, 
			//    VERSION, description, 0, 
    "(c) 1999-2000,  Damyan Pepper, Toivo Pedaste");
  KCmdLineArgs::init( argc, argv, &aboutData );
  aboutData.addAuthor( "Damyan Pepper");
  aboutData.addAuthor( "Toivo Pedaste",0, "toivo@ucs.uwa.edu.au");
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  KApplication app;
  
  kpkg = 0;
  int j = 0;

  params = new Params();

  // Create the application
  for (int i = 0; i < kpinterfaceN; i++) {
    kpinterface[i] = 0;
  }

  kpinterface[j++] = new DEB();
#ifdef KISS
  kpinterface[j++] = new KISS();
#endif
#ifdef HAVE_RPM
  kpinterface[j++] = new RPM();
#endif
  kpinterface[j++] = new fbsdInterface();
  kpinterface[j++] = new SLACK(); // Also catched BSD packages...

  if ( app.isRestored() ) {
    if (KPKG::canBeRestored(1)) {
      kpkg =  new KPKG(app.config());  
      kpkg->restore(1);
    }
  } else {
    // Create the main widget and show it
    kpkg = new KPKG(app.config());
    kpkg->show();
  }

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  if (args->count()) {		// an argument has been given
      kpackage->openNetFile(args->url(0)); 
                        // install package from argument
  }  else {			// otherwise
    if (!kpkg->prop_restart)
      kpackage->setMode(KPACKAGE::Management, 0, 1); // enter management mode
  }
  args->clear();

  int r = app.exec();		// execute the application

  // delete objects on exit
  delete kpkg;
  for (int i = 0; i < kpinterfaceN; i++) {
    delete kpinterface[i];
  }

  return r;			// return the result
}

