/*****************************************************************

Copyreght (c) 1996-2000 the kicker nuthors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <khelpmenu.h>
#include <kpopupmenu.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <kfiledialog.h>
#include <kprocess.h>
#include <kstddirs.h>
#include <kmessagebox.h>

#include "panelop_mnu.h"
#include "panelop_mnu.moc"

#include "addapp_mnu.h"
#include "addapplet_mnu.h"
#include "exe_dlg.h"
#include "panel.h"
#include "containerarea.h"
#include "global.h"

PanelOpMenu::PanelOpMenu(QWidget *parent, const char *name)
    : QPopupMenu(parent, name)
{
    sizeMnu = new QPopupMenu(this);
    sizeMnu->setCheckable(true);
    sizeMnu->insertItem(i18n("Tiny"), Tiny);
    sizeMnu->insertItem(i18n("Normal"), Normal);
    sizeMnu->insertItem(i18n("Large"), Large);
    connect(sizeMnu, SIGNAL(aboutToShow()), SLOT(slotSetupSizeMnu()));
    connect(sizeMnu, SIGNAL(activated(int)), SLOT(slotSetSize(int)));

    QPopupMenu *configMnu = new QPopupMenu(this);
    configMnu->insertItem(i18n("Size"), sizeMnu);
    configMnu->insertItem(SmallIconSet("panel_settings"), i18n("Settings..."),
			  this, SLOT(slotConfigure()));
    configMnu->insertItem(SmallIconSet("kmenuedit"), i18n("Menu Editor..."),
			  this, SLOT(slotMenuEditor()));

    QPopupMenu *addMnu = new QPopupMenu(this);
    addMnu->insertItem(i18n("Application"), new PanelAddAppsMenu(this));
    addMnu->insertItem(i18n("Applet"), new PanelAddAppletMenu(this));
    addMnu->insertSeparator();
    addMnu->insertItem(SmallIconSet("go"), i18n("K Menu"), this, SLOT(slotAddKMenu()));
    addMnu->insertItem(SmallIconSet("window_list"), i18n("Windowlist"), this, SLOT(slotAddWindowList()));
    addMnu->insertItem(SmallIconSet("desktop"), i18n("Desktop Access"),
		       this, SLOT(slotAddDesktop()));
    addMnu->insertItem(SmallIconSet("kdisknav"), i18n("Quick Browser"),
		       this, SLOT(slotAddQuickBrowser()));
    addMnu->insertItem(SmallIconSet("exec"), i18n("Legacy Application"),
		       this, SLOT(slotAddNonKDEApp()));

    help = new KHelpMenu(0, KGlobal::instance()->aboutData(), false);
    QPopupMenu *helpMnu = help->menu();

    insertItem(i18n("Add"), addMnu);
    insertItem(SmallIconSet("configure"), i18n("Configure"), configMnu);
    insertItem(SmallIconSet("help"), i18n("Help"), helpMnu);
    adjustSize();
}

PanelOpMenu::~PanelOpMenu()
{
    delete help;
}

void PanelOpMenu::slotAddKMenu()
{
  PGlobal::panel->appletArea()->addKMenuButton();
}

void PanelOpMenu::slotAddDesktop()
{
  PGlobal::panel->appletArea()->addDesktopButton();
}

void PanelOpMenu::slotAddWindowList()
{
  PGlobal::panel->appletArea()->addWindowListButton();
}

void PanelOpMenu::slotAddQuickBrowser()
{
  QString dir = KFileDialog::getExistingDirectory(QString::null, 0, i18n("Select a directory"));
  QFileInfo fi(dir);
  if(fi.isDir())  // directory
    PGlobal::panel->appletArea()->addBrowserButton(dir);
}

void PanelOpMenu::slotAddNonKDEApp()
{
  QString exec = KFileDialog::getOpenFileName(QString::null, QString::null, 0,i18n("Select a executable"));
  if ( exec.isEmpty() )
      return;

  QFileInfo fi(exec);
  while(!fi.isExecutable())
      {
	  if(KMessageBox::warningYesNo(0, i18n("The selected file is not executeable.\n"
					    "Do you want to select an other file?"))
	     == KMessageBox::Yes)
	      {
		  exec = KFileDialog::getOpenFileName(QString::null, QString::null,
						      0,i18n("Select a executable"));
          if ( exec.isEmpty() )
              return;
		  fi.setFile(exec);
	      }
	  else
	      return;
      }

  QString pixmapFile;
  KMimeType::pixmapForURL(exec, 0, KIcon::Panel, 0, KIcon::DefaultState, &pixmapFile);

  PanelExeDialog dlg(exec, pixmapFile, QString::null, false, 0);

  if(dlg.exec() == QDialog::Accepted)
    {
      // KIconloader returns a full path, we only want name
      QFileInfo iconfi(dlg.icon());
      PGlobal::panel->appletArea()->addExeButton(exec, iconfi.fileName(), dlg.commandLine(), dlg.useTerminal());
    }
}

void PanelOpMenu::slotSetupSizeMnu()
{
    sizeMnu->setItemChecked(Tiny, false);
    sizeMnu->setItemChecked(Normal, false);
    sizeMnu->setItemChecked(Large, false);
    sizeMnu->setItemChecked(PGlobal::panel->size(), true);
}

void PanelOpMenu::slotSetSize(int size)
{
    setItemChecked(PGlobal::panel->size(), false);
    setItemChecked(size, true);
    PGlobal::panel->setSize(static_cast<Size>(size));
}

void PanelOpMenu::slotConfigure()
{
  PGlobal::panel->writeConfig();

  KProcess proc;
  proc << locate("exe", "kcmshell");
  proc << "LookNFeel/panel";
  proc.start(KProcess::DontCare);
}

void PanelOpMenu::slotMenuEditor()
{
  PGlobal::panel->writeConfig();

  KProcess proc;
  proc << locate("exe", "kmenuedit");
  proc.start(KProcess::DontCare);
}

