/**************************************************************************

    config.cpp  - KPager config dialog
    Copyright (C) 2000  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to larrosa@kde.org

***************************************************************************/

#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qwidget.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qlayout.h>

#include <kdialogbase.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapp.h>
#include <kdebug.h>

#include "config.h"
#include "config.moc"
#include "desktop.h"
#include "kpager.h"


KPagerConfigDialog::KPagerConfigDialog (QWidget *parent)
 : KDialogBase ( parent, "configdialog", true, "KPager Settings", Ok|Cancel, Ok, true )
{
    QHBox *page = new QHBox( this );
    QVBox *lpage = new QVBox( page );
    setMainWidget(page);

    m_chkShowName=new QCheckBox(i18n("Show Name"),lpage,0);
    connect(m_chkShowName, SIGNAL(toggled(bool)), this, SLOT(setShowName(bool)));
    m_chkShowNumber=new QCheckBox(i18n("Show Number"),lpage,0);
    connect(m_chkShowNumber, SIGNAL(toggled(bool)), this, SLOT(setShowNumber(bool)));
    m_chkShowBackground=new QCheckBox(i18n("Show Background"),lpage,0);
    connect(m_chkShowBackground, SIGNAL(toggled(bool)), this, SLOT(setShowBackground(bool)));
    m_chkShowWindows=new QCheckBox(i18n("Show Windows"),lpage,0);
    connect(m_chkShowWindows, SIGNAL(toggled(bool)), this, SLOT(setShowWindows(bool)));

    m_grpWindowDrawMode=new QButtonGroup(i18n("Type of Window"),page);
    m_grpWindowDrawMode->setExclusive(true);
    QVBoxLayout *vbox = new QVBoxLayout(m_grpWindowDrawMode, KDialog::marginHint(),
					KDialog::spacingHint());
    vbox->addSpacing(fontMetrics().lineSpacing());
    vbox->addWidget(new QRadioButton(i18n("Plain"),m_grpWindowDrawMode));
    vbox->addWidget(new QRadioButton(i18n("Icon"),m_grpWindowDrawMode));

    QRadioButton *rbpix = new QRadioButton(i18n("Pixmap"),m_grpWindowDrawMode);
//    rbpix->setEnabled(false);				
    vbox->addWidget(rbpix);

    connect(m_grpWindowDrawMode, SIGNAL(clicked(int)), this, SLOT(setWindowDrawMode(int)));

    m_grpLayoutType=new QButtonGroup(i18n("Layout"),page);
    m_grpLayoutType->setExclusive(true);
    vbox = new QVBoxLayout(m_grpLayoutType, KDialog::marginHint(), KDialog::spacingHint());
    vbox->addSpacing(fontMetrics().lineSpacing());
    vbox->addWidget(new QRadioButton(i18n("Classical"),m_grpLayoutType));
    vbox->addWidget(new QRadioButton(i18n("Horizontal"),m_grpLayoutType));
    vbox->addWidget(new QRadioButton(i18n("Vertical"),m_grpLayoutType));

    connect(m_grpLayoutType, SIGNAL(clicked(int)), this, SLOT(setLayout(int)));

    loadConfiguration();
    setMinimumSize(360, 160);
}

void KPagerConfigDialog::setShowName(bool show)
{
    m_showName=show;
}

void KPagerConfigDialog::setShowNumber(bool show)
{
    m_showNumber=show;
}

void KPagerConfigDialog::setShowBackground(bool show)
{
    m_showBackground=show;
}

void KPagerConfigDialog::setShowWindows(bool show)
{
    m_showWindows=show;
}

void KPagerConfigDialog::setWindowDrawMode(int type)
{
    m_windowDrawMode=type;
}

void KPagerConfigDialog::setLayout(int layout)
{
    m_layoutType=layout;
}

void KPagerConfigDialog::loadConfiguration()
{
    KConfig *cfg= kapp->config();

    m_windowDrawMode=cfg->readNumEntry("windowDrawMode", Desktop::c_defWindowDrawMode);
    m_showName=cfg->readBoolEntry("showName", Desktop::c_defShowName);
    m_showNumber=cfg->readBoolEntry("showNumber", Desktop::c_defShowNumber);
    m_showBackground=cfg->readBoolEntry("showBackground", Desktop::c_defShowBackground);
    m_showWindows=cfg->readBoolEntry("showWindows", Desktop::c_defShowWindows);
    m_layoutType=cfg->readNumEntry("layoutType", KPager::c_defLayout);

    m_chkShowName->setChecked(m_showName);
    m_chkShowNumber->setChecked(m_showNumber);
    m_chkShowBackground->setChecked(m_showBackground);
    m_chkShowWindows->setChecked(m_showWindows);
    m_grpWindowDrawMode->setButton(m_windowDrawMode);
    m_grpLayoutType->setButton(m_layoutType);
}

bool KPagerConfigDialog::m_showName=Desktop::c_defShowName;
bool KPagerConfigDialog::m_showNumber=Desktop::c_defShowNumber;
bool KPagerConfigDialog::m_showBackground=Desktop::c_defShowBackground;
bool KPagerConfigDialog::m_showWindows=Desktop::c_defShowWindows;
int  KPagerConfigDialog::m_windowDrawMode=Desktop::c_defWindowDrawMode;
int  KPagerConfigDialog::m_layoutType=KPager::c_defLayout;
