/**
 * email.h
 *
 * Copyright (c) 1999 Preston Brown <pbrown@redhat.com>
 * Copyright (c) 2000 Frerich Raabe <raabe@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _EMAIL_H
#define _EMAIL_H

#include <kcmodule.h>

class QLineEdit;
class QRadioButton;
class QButtonGroup;
class QPushButton;
class QCheckBox;

class KEmailConfig : public KCModule
{
  Q_OBJECT
public:
  KEmailConfig(QWidget *parent = 0L, const char *name = 0L);
  virtual ~KEmailConfig();

  void load();
  void save();
  void defaults();
  
  int buttons();
  QString quickHelp() const;
  
public slots:
  void configChanged();
  void selectEmailClient();
      
private:
 QLineEdit *fullName, *organization;
 QLineEdit *emailAddr, *replyAddr;

 QLineEdit *userName, *password, *inServer, *outServer, *emailClient;
 QButtonGroup *bGrp;
 QRadioButton *pop3Button, *imapButton, *localButton;
 QPushButton *bEmailClient;
 QCheckBox *cTerminalClient;

};

#endif
