/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qpushbutton.h>
#include <qpixmap.h>
#include <qobjectlist.h>
#include <qapplication.h>

#include <kdebug.h>

#include "panner.h"
#include "panner.moc"

const int arrow = 12;

Panner::Panner( Orientation orientation, QWidget* parent, const char* name )
    : QScrollView( parent, name ), orient(orientation)
{
    setResizePolicy(Manual);
    setVScrollBarMode( QScrollView::AlwaysOff );
    setHScrollBarMode( QScrollView::AlwaysOff );

    viewport()->installEventFilter( this );
    viewport()->setBackgroundMode( PaletteBackground );

    leftArrow = new QPushButton( this );
    leftArrow->setAutoRepeat(true);
    connect( leftArrow, SIGNAL( clicked() ), this, SLOT( scrollLeft() ) );

    rightArrow = new QPushButton( this );
    rightArrow->setAutoRepeat(true);
    connect( rightArrow, SIGNAL( clicked() ), this, SLOT( scrollRight() ) );

    upArrow = new QPushButton( this );
    upArrow->setAutoRepeat(true);
    connect( upArrow, SIGNAL( clicked() ), this, SLOT( scrollUp() ) );

    downArrow = new QPushButton( this );
    downArrow->setAutoRepeat(true);
    connect( downArrow, SIGNAL( clicked() ), this, SLOT( scrollDown() ) );
}

Panner::~Panner() {}

void Panner::resizeContents( int w, int h )
{
    QScrollView::resizeContents(w, h);
}

void Panner::setOrientation(Orientation orientation)
{
    orient = orientation;
    resize(size());
}

void Panner::resizeEvent( QResizeEvent* e )
{
    QScrollView::resizeEvent( e );
    leftArrow->setGeometry( width() - 2*arrow, 0, arrow, height() );
    rightArrow->setGeometry( width() - arrow, 0, arrow, height() );
    upArrow->setGeometry( 0, height() - 2*arrow, width(), arrow );
    downArrow->setGeometry( 0, height() - arrow, width(), arrow );

    setButtonPixmap( leftArrow, LeftArrow );
    setButtonPixmap( rightArrow, RightArrow );
    setButtonPixmap( upArrow, UpArrow );
    setButtonPixmap( downArrow, DownArrow );

    layoutChildren();
    updateArrows();
}

void Panner::setButtonPixmap( QPushButton* b, Qt::ArrowType type )
{
    QPixmap pm( b->size() );
    QPainter p( &pm );
    p.fillRect( QRect( 0, 0, pm.width(), pm.height() ),
		colorGroup().brush( QColorGroup::Button ) );
    style().drawArrow( &p, type, FALSE, 0, 0, pm.width(),
		       pm.height(), colorGroup(), b->isEnabled() );
    p.end();
    b->setPixmap( pm );
}

void Panner::scrollRight()
{
    scrollBy( 30, 0 );
}

void Panner::scrollLeft()
{
    scrollBy( -30, 0 );
}

void Panner::scrollUp()
{
    scrollBy( 0, -30 );
}

void Panner::scrollDown()
{
    scrollBy( 0, 30 );
}

bool Panner::eventFilter( QObject *, QEvent * e)
{
    if ( e->type() == QEvent::LayoutHint ) {
	layoutChildren();
	updateArrows();
    }
    return false;
}

void Panner::updateArrows()
{
    if ( contentsWidth() -1 > width() && orient == Horizontal ) {
	leftArrow->show();
	rightArrow->show();
    }
    else {
	leftArrow->hide();
	rightArrow->hide();
    }
    if ( contentsHeight()-1 > height() && orient == Vertical ) {
	upArrow->show();
	downArrow->show();
    }
    else {
	upArrow->hide();
	downArrow->hide();
    }
}
