#include <qfile.h>
#include <qtextstream.h>
#include <qdir.h>


#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>


#include "rules.h"


KeyRules::KeyRules(QString rule, QString path)
{
  // determine the locale to use
  QStringList::Iterator it;

  // try to load the right files
  if (!path.isEmpty())
    {
      loadRules(QString("%1/%2.lst").arg(path).arg(rule));
      loadRules(QString("%1/%2-%3.lst").arg(path).arg(rule).arg(KGlobal::locale()->language()));
    }
  
  loadRules(QString("/usr/X11R6/lib/X11/xkb/rules/%1.lst").arg(rule));
  loadRules(QString("/usr/X11R6/lib/X11/xkb/rules/%1-%2.lst").arg(rule).arg(KGlobal::locale()->language()));

  loadEncodings(QString("/usr/X11R6/lib/X11/locale/locale.alias"));
}


void KeyRules::loadRules(QString file)
{
  QFile f(file);
  if (f.open(IO_ReadOnly))
    {
      QTextStream ts(&f);

      QString line;
      bool model=false, layout=false;
      while (!ts.eof())
	{
	  line = ts.readLine().stripWhiteSpace();

	  if (!model && line.left(7) == "! model")
	    {
	      model = true;
	      continue;
	    }
	  if (!layout && line.left(8) == "! layout")
	    {
	      layout = true;
	      continue;
	    }

	  if (model)
	    if (line.isEmpty())
	      model = false;
	    else
	      {
		int pos = line.find(QRegExp("\\s"));
		if (pos > 0)		  
		  {
		    _models.remove(line.left(pos));		    
		    _models.insert(line.left(pos), strdup(line.mid(pos).stripWhiteSpace().latin1()));
		  }
	      }
	  
	  if (layout)
	    if (line.isEmpty())
	      layout = false;
	    else
	      {
		int pos = line.find(QRegExp("\\s"));
		if (pos > 0)
		  {
		    _layouts.remove(line.left(pos));
		    _layouts.insert(line.left(pos), strdup(line.mid(pos).stripWhiteSpace().latin1()));
		  }
	      }
	}

      f.close();
    }
}

// some handcoded ones, because the X11 locale file doesn't get them correctly, or in case
// the locale file wasn't found
static const char * const encs[] = {
     "be", "ISO8859-1",
     "br", "ISO8859-1",
     "bg", "ISO8859-5",
     "ca", "ISO8859-1",
     "cs", "ISO8859-2",
     "cz", "ISO8859-2",
     "de", "ISO8859-1",
     "de_CH", "ISO8859-1",
     "dk", "ISO8859-1",
     "ee", "ISO8859-4",
     "en_US", "ISO8859-1",
     "el", "ISO8859-7",
     "es", "ISO8859-1",
     "eo", "ISO8859-3",
     "fi", "ISO8859-1",
     "fr", "ISO8859-1",
     "fr_CH", "ISO8859-1",
     "he", "ISO8859-8",
     "hu", "ISO8859-2",
     "hr", "ISO8859-2",
     "it", "ISO8859-1",
     "kl", "ISO8859-1",
     "lt", "ISO8859-4",
     "mk", "ISO8859-5",
     "nl", "ISO8859-1",
     "no", "ISO8859-1",
     "pl", "ISO8859-2",
     "pt", "ISO8859-1",
     "ro", "ISO8859-2",
     "ru", "KOI8-R",
     "ru_UA", "KOI8-U",
     "se", "ISO8859-1",
     "br", "ISO8859-1",
     "th", "ISO8859-11",
     "us", "ISO8859-1",
     0, 0
};

void KeyRules::loadEncodings(QString file)
{
  QFile f(file);
  if (f.open(IO_ReadOnly))
    {
      QTextStream ts(&f);

      QString line;
      while (!ts.eof()) {
	  line = ts.readLine().simplifyWhiteSpace();

	    if (line[0] == '#' || line.isEmpty())
		continue;

	    int pos = line.find(' ');
	    if (pos > 0) {
		_encodings.remove(line.left(pos));
		int pos2 = line.find('.', pos);
		_encodings.insert(line.left(pos), strdup(line.mid(pos2+1).stripWhiteSpace().latin1()));
	    }
      }

      f.close();
    }

  int i = 0;
  while ( encs[i] ) {
      _encodings.remove(encs[i]);
      _encodings.insert(encs[i], encs[i+1]);
      i += 2;
  }
}


QStringList KeyRules::rules(QString path)
{
  QStringList result;

  if (path.isEmpty())
    path = "/usr/X11R6/lib/X11/xkb/rules";
  
  QDir dir(path);
  dir.setFilter(QDir::Files);
  QStringList list = dir.entryList();
  for (QStringList::Iterator it = list.begin(); it != list.end(); ++it)
    if ((*it).right(4) != ".lst")
      result << *it;
  
  return result;
}
