/*
 * krootwm.h Part of the KDE project.
 *
 * Copyright (C) 1997 Matthias Ettrich
 *           (C) 1997 Torben Weis, weis@kde.org
 *           (C) 1998 S.u.S.E, weis@suse.de
 */

#ifndef __krootwm_h__
#define __krootwm_h__

#include <qobject.h>
#include "minicli.h"

// we need Window but do not want to include X.h since it
// #defines way too many constants
typedef unsigned long XID;
typedef XID Window;

class KMenuBar;
class KDesktop;
class QPopupMenu;
class KNewMenu;
class KWinModule;
class KBookmarkMenu;
class KHelpMenu;
class KActionCollection;
class KActionMenu;

enum {
  ITEM_HELP=100,
  ITEM_PASTE,
  ITEM_EXECUTE,
  ITEM_CONFIGURE_BACKGROUND,
  ITEM_CONFIGURE_ICONS,
  ITEM_UNCLUTTER_WINDOWS,
  ITEM_CASCADE_WINDOWS,
  ITEM_ARRANGE_ICONS,
  ITEM_LOCK_SCREEN,
  ITEM_LOGOUT
};

class KRootWm: public QObject {
  Q_OBJECT

public:
  KRootWm(KDesktop*);
  ~KRootWm();

  void mousePressed( const QPoint& _global, int _button );
  bool hasLeftButtonMenu() { return leftButtonChoice != NOTHING; }

  /**
   * Return the unique KRootWm instance
   */
  static KRootWm * getRootWm() { return s_rootWm; }

  /**
   * share this with desktop.cc
   */
  KNewMenu * newMenu() { return menuNew; }

  /**
   * Read and apply configuration
   */
  void initConfig();

  void saveConfig() { miniCli->saveConfig(); }

public slots:
  void slotExec();
  void slotArrangeIcons();
  void slotLineupIcons();
  void slotConfigureBackground();
  void slotConfigureDesktop();
  void slotToggleDesktopMenu();
  void slotUnclutterWindows();
  void slotCascadeWindows();
  void slotHelp();
  void slotPaste();
  void slotLock();
  void slotLogout();

 private slots:
 void slotAppearanceChanged();
    
private:
  KDesktop* m_pDesktop;

  // The three root menus :
  QPopupMenu* windowListMenu;
  QPopupMenu* desktopMenu;
  // the appMenu is (will be) provided by kicker

  // Configuration for the root menus :
  typedef enum { NOTHING = 0, WINDOWLISTMENU, DESKTOPMENU, APPMENU } menuChoice;
  menuChoice leftButtonChoice;
  menuChoice middleButtonChoice;
  menuChoice rightButtonChoice;

  KNewMenu* menuNew;
  KActionMenu* bookmarks;
  KBookmarkMenu* bookmarkMenu;
  Minicli *miniCli;
  KActionCollection * m_actionCollection;

  void activateMenu( menuChoice choice, const QPoint& global );
  void buildMenus();

  bool showMenuBar;
  bool globalMenuBar;
  KMenuBar *menuBar;

  QPopupMenu *file;
  QPopupMenu *desk;
  KHelpMenu *help;

  QPixmap defaultPixmap;

  static KRootWm * s_rootWm;

  bool m_bInit;

private slots:

  void slotMenuItemActivated(int);
  void slotWindowItemActivated(int);
  void slotFileNewAboutToShow();
  void generateWindowlist();
};

#endif
