/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __hidebutton_h__
#define __hidebutton_h__

#include <qbutton.h>

#include "global.h"

class HideButton : public QButton
{
  Q_OBJECT

 public:
  HideButton(Position pos, QWidget *parent=0, const char *name=0);

  QSize sizeHint() const { return QWidget::sizeHint(); }
  QSizePolicy sizePolicy() const { return QWidget::sizePolicy(); }

  void configure();
  
 public slots:
  void setPosition(Position pos);

 protected:
  void paintEvent(QPaintEvent *);
  virtual void enterEvent(QEvent *);
  virtual void leaveEvent(QEvent *);

  bool _highlight;
  bool _dohighlight;
  Position _pos;
};


#endif // __hidebutton_h__

