/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qvaluelist.h>

#include <kwin.h>
#include <kwinmodule.h>
#include <klocale.h>
#include <kstringhandler.h>
#include <netwm.h>
#include <kapp.h>
#include <dcopclient.h>

#include "global.h"
#include "windowlist_mnu.h"
#include "windowlist_mnu.moc"

PanelWindowListMenu::PanelWindowListMenu(QWidget *parent, const char *name)
  : QPopupMenu(parent, name)
{
    connect(this, SIGNAL(activated(int)),
	    SLOT(slotExec(int)));
}

void PanelWindowListMenu::slotExec(int id)
{
    if (id > 1000) {
	NETRootInfo info( x11Display(), 0 );
	info.setCurrentDesktop(id - 1000 );
    }  else if ( id >= 0 )  {
	WId w = PGlobal::kwin_module->windows()[id];
	KWin::setActiveWindow(w);
    }
}


void PanelWindowListMenu::slotUnclutterWindows() {
    kapp->dcopClient()->send("kwin", "KWinInterface", "unclutterDesktop()", "");
}

void PanelWindowListMenu::slotCascadeWindows() {
    kapp->dcopClient()->send("kwin", "KWinInterface", "cascadeDesktop()", "");
}


/**
 * Generate the list of windows
 **/
void PanelWindowListMenu::init()
{
    int i, d;

    int nd = PGlobal::kwin_module->numberOfDesktops();
    int cd = PGlobal::kwin_module->currentDesktop();
    WId active_window = PGlobal::kwin_module->activeWindow();

    clear();

    insertItem( i18n("Unclutter Windows"),
		this, SLOT( slotUnclutterWindows() ) );
    insertItem( i18n("Cascade Windows"),
		this, SLOT( slotCascadeWindows() ) );

    insertSeparator();
    for (d = 1; d <= nd; d++) {
	if (nd > 1)
	    insertItem( PGlobal::kwin_module->desktopName( d ), 1000 + d);

	int items = 0;
	
	if (!active_window && d == cd)
	    setItemChecked(1000 + d, TRUE);

	QValueList<WId>::ConstIterator it;
	for (it = PGlobal::kwin_module->windows().begin(), i = 0;
	     it != PGlobal::kwin_module->windows().end(); ++it, ++i) {
	    KWin::Info info = KWin::info( *it );
	    if ( (info.desktop == d ) || (d == cd && info.onAllDesktops ) ) {
		QString title = info.visibleNameWithState();
		if ( info.windowType == NET::Normal || info.windowType == NET::Unknown ) {
		    QPixmap pm = KWin::icon(*it, 16, 16, true );
		    items++;
		    insertItem( pm, QString("   ")+ KStringHandler::csqueeze(title,25),i);
		    if (*it == active_window)
			setItemChecked(i, TRUE);
		}
	    }
	}
	if (d < nd)
	    insertSeparator();
    }
    adjustSize();
}

