/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// QT includes
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>

// KDE includes
#include <klocale.h>
#include <kapp.h>
#include <kconfig.h>

// own includes
#include "optionsdlg.h"
#include "defines.h"

OptionsDlg::OptionsDlg(QWidget* parent, const char* name, int _players) : QDialog(parent, name, true)
{
 resize(500, 400);

 if (_players <= 0)
	players = DEFAULT_PLAYERS;
 else
	 players = _players;
 

 const int labelPos = 10;
 const int widgetPos = 300;
 int y = 10;

 QPushButton* ok = new QPushButton(i18n("OK"), this);
 ok->move(this->width() /4 - ok->width() /2, 350);
 ok->setDefault(true);
 connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
 
 QPushButton* cancel = new QPushButton(i18n("Cancel"), this);
 cancel->move(this->width() /2 + this->width() /4 - cancel->width() /2, 350);
 connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));
 
 QLabel* note = new QLabel(i18n("All changes will be activated in the next round"), this);
 note->adjustSize();
 note->move(this->width() /2 - note->width() /2, y);
 y += 30;

 QLabel* drawDelayLabel = new QLabel(i18n("Draw delay:"), this);
 drawDelayLabel->adjustSize();
 drawDelayLabel->move(labelPos, y); 
 drawDelay = new QLineEdit(this);
 drawDelay->move(widgetPos, y);

 if (players > 1) {
	 y += 35;
	 QLabel* maxBetLabel = new QLabel(i18n("Maximal bet:"), this);
	 maxBetLabel->adjustSize();
	 maxBetLabel->move(labelPos, y);
	 maxBet = new QLineEdit(this);
	 maxBet->move(widgetPos, y);

	 y += 35;

	 QLabel* minBetLabel = new QLabel(i18n("Minimal bet:"), this);
	 minBetLabel->adjustSize();
	 minBetLabel->move(labelPos, y);
	 minBet = new QLineEdit(this);
	 minBet->move(widgetPos, y);
 }
 else {
 	 y += 35;
	 QLabel* maxBetLabel = new QLabel(i18n("Cash Per Round:"), this);
	 maxBetLabel->adjustSize();
	 maxBetLabel->move(labelPos, y);
	 maxBet = new QLineEdit(this);
	 maxBet->move(widgetPos, y);
 }
}

OptionsDlg::~OptionsDlg()
{
}

void OptionsDlg::init(int _drawDelay, int _maxBetOrCashPerRound, int _minBet)
{
 if (_minBet < 0)
	defaultMinBet = MIN_BET;
 if (_maxBetOrCashPerRound < 0 && players > 1)
	defaultMaxBet = MAX_BET;
 else if (_maxBetOrCashPerRound < 0)
	defaultCashPerRound = CASH_PER_ROUND;
 if (_drawDelay < 0)
	_drawDelay = DRAWDELAY;

 drawDelay->setText(QString("%1").arg(_drawDelay));
 maxBet->setText(QString("%1").arg(_maxBetOrCashPerRound));
 if (players > 1)
	minBet->setText(QString("%1").arg(_minBet));
}

int OptionsDlg::getMaxBet()
{
 if (players <= 1)
	return defaultMaxBet;
 bool ok = true;
 int a = maxBet->text().toInt(&ok);
 if (!ok || a <= 0 || a < getMinBet()) {
	a = defaultMaxBet;
	if (a < getMinBet())
		a = getMinBet();
 }
 return a;
}

int OptionsDlg::getMinBet()
{
 if (players <= 1)
	return defaultMinBet;
 bool ok = true;
 int a = minBet->text().toInt(&ok);
 if (!ok || a < 0) // 0 is allowed
 	return defaultMinBet;
 return a;
}

int OptionsDlg::getCashPerRound()
{
 if (players > 1)
	return defaultCashPerRound;
 bool ok = true;
 int a = maxBet->text().toInt(&ok);
 if (!ok || a < 0) // 0 is allowed
	return defaultCashPerRound;
 return a;
}

int OptionsDlg::getDrawDelay()
{
 bool ok = true;
 int a = drawDelay->text().toInt(&ok);
 if (!ok || a < 0) 
	return defaultDrawDelay;
 return a;
}

#include "optionsdlg.moc"
