/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */  

// QT includes
#include<qpopupmenu.h>
#include<qlayout.h>
#include<qpixmap.h>
#include<qkeycode.h>

// KDE includes
#include <kiconloader.h>
#include <kapp.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kmessagebox.h>
#include <kconfig.h>
#include <klocale.h>
#include <kstdaccel.h>

// own includes
#include "top.h"
#include "kpoker.h"
#include "defines.h"

#include "version.h"

PokerWindow::PokerWindow() : KMainWindow(0)
{
        setCaption("");
	_kpok = new kpok(this, 0);
	setCentralWidget( _kpok );
	_kpok->show();
	connect(_kpok, SIGNAL(changeLastHand(QString, bool)), this, SLOT(setHand(QString, bool)));
	
	LHLabel = new QLabel(statusBar());
	LHLabel->adjustSize();
	statusBar()->addWidget(LHLabel, 0, true);
	_kpok->updateLHLabel();

	connect(_kpok, SIGNAL(showClickToHold(bool)), this, SLOT(showClickToHold(bool)));

	
	filePopup = new QPopupMenu(0,"fpopup");
	filePopup->insertItem(SmallIcon("filenew"),i18n("&New game"), _kpok, SLOT(newGame()), KStdAccel::openNew(), ID_NEWGAME);
	filePopup->insertItem(SmallIcon("filesave"),i18n("&Save game"), _kpok, SLOT(saveGame()), KStdAccel::save(), ID_SAVEGAME);
	filePopup->insertSeparator();
	filePopup->insertItem(SmallIcon("exit"),i18n("&Quit"), this, SLOT(close()), KStdAccel::quit(), ID_EXIT);
	connect(filePopup, SIGNAL(activated(int)), _kpok, SLOT(commandCallback(int)));
	connect(filePopup, SIGNAL(activated(int)), this, SLOT(commandCallback(int)));

       	optionsPopup = new QPopupMenu(this, "oppup");
	optionsPopup->insertItem(i18n("Soun&d"), ID_SOUND);
	optionsPopup->insertItem(i18n("&Blinking"), ID_BLINKING);
	optionsPopup->insertItem(i18n("&Adjust Bet is default"), ID_ADJUST);
	optionsPopup->insertItem(i18n("&Save Options"), this, SLOT(saveOptions()), 0, ID_SAVEOPTIONS);
	optionsPopup->insertSeparator();
	optionsPopup->insertItem(SmallIcon("configure"),i18n("&Preferences..."), ID_OPTIONS);

	optionsPopup->setCheckable(true);
	connect(optionsPopup, SIGNAL(activated(int)), _kpok, SLOT(commandCallback(int)));
	connect(optionsPopup, SIGNAL(activated(int)), this, SLOT(commandCallback(int)));

	menuBar()->insertItem(i18n("&Game"), filePopup);
	menuBar()->insertItem(i18n("&Settings"), optionsPopup);
	
	menuBar()->insertSeparator();
	menuBar()->insertItem(i18n("&Help"), helpMenu(0, false)); // let's use the global about box

	KConfig* conf = kapp->config();
	if (conf != 0) {
		int key = conf->readBoolEntry("Sound", SOUND_DEFAULT);
		_kpok->setSound(key);
		optionsPopup->setItemChecked(ID_SOUND, key);

		key = conf->readBoolEntry("Blinking", BLINKING_DEFAULT);
		_kpok->setBlinking(key);
		optionsPopup->setItemChecked(ID_BLINKING, key);
		
		key = conf->readBoolEntry("Adjust", ADJUST_DEFAULT);
		_kpok->setAdjust(key);
		optionsPopup->setItemChecked(ID_ADJUST, key);
	} else {
		if (_kpok->initSound() && SOUND_DEFAULT) 
		  	optionsPopup->setItemChecked(ID_SOUND, true);
		else
		  	optionsPopup->setItemChecked(ID_SOUND, true);
		_kpok->setBlinking(BLINKING_DEFAULT);
		_kpok->setAdjust(ADJUST_DEFAULT);
		optionsPopup->setItemChecked(ID_BLINKING, BLINKING_DEFAULT);
		optionsPopup->setItemChecked(ID_ADJUST, ADJUST_DEFAULT);
	}
}

PokerWindow::~PokerWindow()
{
//? delete _kpok;
}


void PokerWindow::saveProperties(KConfig* conf)
{
 conf->writeEntry("Sound", optionsPopup->isItemChecked(ID_SOUND));
 conf->writeEntry("Blinking", optionsPopup->isItemChecked(ID_BLINKING));
 conf->writeEntry("Adjust", optionsPopup->isItemChecked(ID_ADJUST));
// and further? - save the game?
 _kpok->saveGame(conf);
}

void PokerWindow::readProperties(KConfig* conf)
{
 int i = 0;
 i = conf->readBoolEntry("Sound", SOUND_DEFAULT);
 _kpok->setSound(i);
 optionsPopup->setItemChecked(ID_SOUND, i);

 i = conf->readBoolEntry("Blinking", BLINKING_DEFAULT);
 _kpok->setBlinking(i);
 optionsPopup->setItemChecked(ID_BLINKING, i);
		
 i = conf->readBoolEntry("Adjust", ADJUST_DEFAULT);
 _kpok->setAdjust(i);
 optionsPopup->setItemChecked(ID_ADJUST, i);

 _kpok->loadGame(conf);
}

void PokerWindow::commandCallback(int id)
{
 switch(id){
	case ID_NEWGAME:
	case ID_SAVEGAME:
	case ID_EXIT:
		break;
	case ID_SOUND:
	case ID_BLINKING:
	case ID_ADJUST:
 		optionsPopup->setItemChecked(id, !optionsPopup->isItemChecked(id));
		break;
 }
}

bool PokerWindow::queryClose()
{
 switch(KMessageBox::warningYesNoCancel(this, i18n("Do you want to save this game?"))) {
	case KMessageBox::Yes :
		_kpok->saveGame();
		return true;
	case KMessageBox::No :
		return true;
	default :
		return false;
 }
}

void PokerWindow::setHand(QString newHand, bool lastHand)
{
 if (lastHand) 
	LHLabel->setText(i18n("Last hand: ") + newHand);
 else
	LHLabel->setText(i18n("Last winner: ") + newHand);
 LHLabel->adjustSize();
}

void PokerWindow::showClickToHold(bool show)
{
 if (show)
	statusBar()->message(i18n("Click a card to hold it"));
 else
	statusBar()->clear();
}

void PokerWindow::saveOptions()
{
 KConfig* conf = kapp->config();
 conf->setGroup("General");

 conf->writeEntry("Sound", optionsPopup->isItemChecked(ID_SOUND));
 conf->writeEntry("Blinking", optionsPopup->isItemChecked(ID_BLINKING));
 conf->writeEntry("Adjust", optionsPopup->isItemChecked(ID_ADJUST));
}

#include "top.moc"
