#ifndef DIALOGS_H
#define DIALOGS_H

#include <qlineedit.h>
#include <qlayout.h>
#include <qcheckbox.h>

#include <kdialogbase.h>
#include <kconfig.h>
#include <knuminput.h>

#include "types.h"

//-----------------------------------------------------------------------------
class HighScores : public KDialogBase
{
 Q_OBJECT
		
 public:
    HighScores(const GameOverItem *, QWidget *parent, const char *name = 0);

	static int betterEntry(const GameOverItem *);

 private slots:
    void reject();
	
 private:
	int        bEntry;
	QLineEdit *qle;
	bool       _close;

	static uint nbEntries();
};

//-----------------------------------------------------------------------------
class MultiScores : public KDialogBase
{
 public:
	MultiScores(uint nbPlayers, QWidget *parent, const char *name = 0);
	void add(const GameOverItem &);

 private:
	QGridLayout *grid;
	uint         i;
};

//-----------------------------------------------------------------------------
class OptionDialog : public KDialogBase
{
 Q_OBJECT

 public:
	OptionDialog(QWidget *parent, const char *name = 0);

	static bool readMenuVisible();
	static void writeMenuVisible(bool visible);
	static bool readShadow();
	static bool readShowNext();
	static bool readAnimations();
	static uint readBlockSize();

 private slots:
	void accept();

 private:
	QCheckBox    *shadow, *next, *anim;
	KIntNumInput *ni;

	static KConfig *config();
};

#endif
