/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <qpushbutton.h>

#include <kglobal.h>
#include <klocale.h>

#include "betbox.h"

BetBox::BetBox(QWidget* parent, const char* name) : QGroupBox(parent, name)
{
 QFont myFixedFont("Helvetica", 12);

 bet5Up = new QPushButton(this);
 bet10Up = new QPushButton(this);
 bet5Down = new QPushButton(this);
 bet10Down = new QPushButton(this);
 adjustBet = new QPushButton(this);
 outButton = new QPushButton(this);
 bet5Up->setFont(myFixedFont); bet10Up->setFont(myFixedFont); bet5Down->setFont(myFixedFont); bet10Down->setFont(myFixedFont); adjustBet->setFont(myFixedFont); outButton->setFont(myFixedFont);

 bet5Up->setText(QString("+%1").arg(KGlobal::locale()->formatMoney(5)));
 bet10Up->setText(QString("+%1").arg(KGlobal::locale()->formatMoney(10)));
 bet5Down->setText(QString("-%1").arg(KGlobal::locale()->formatMoney(5)));
 bet10Down->setText(QString("-%1").arg(KGlobal::locale()->formatMoney(10)));
 adjustBet->setText(i18n("Adjust Bet"));
 outButton->setText(i18n("Out"));

//correct the sizes
 const int distance = 3;
 bet5Up->adjustSize();
 bet5Up->move(distance, distance);
 bet10Up->setGeometry(bet5Up->x() + bet5Up->width() + distance, bet5Up->y(), bet10Up->sizeHint().width(), bet5Up->height());
 bet5Down->setGeometry(distance, bet5Up->y() + bet5Up->height() + distance, bet5Up->width(), bet5Down->sizeHint().height());
 bet10Down->setGeometry(bet5Down->x() + bet5Down->width() + distance, bet10Up->y() + bet10Up->height() + distance, bet10Up->width(), bet5Down->height());
 adjustBet->setGeometry(distance, bet5Down->y() + bet5Down->height() + distance, bet5Down->width(), bet5Down->height());
 outButton->setGeometry(adjustBet->x() + adjustBet->width() + distance, bet5Down->y() + bet5Down->height() + distance, bet5Down->width(), bet5Down->height());

//connects
 connect(bet5Up, SIGNAL(clicked()), SLOT(bet5UpClicked()));
 connect(bet10Up, SIGNAL(clicked()), SLOT(bet10UpClicked()));
 connect(bet5Down, SIGNAL(clicked()), SLOT(bet5DownClicked()));
 connect(bet10Down, SIGNAL(clicked()), SLOT(bet10DownClicked()));
 connect(outButton, SIGNAL(clicked()), SLOT(outClicked()));
 connect(adjustBet, SIGNAL(clicked()), SLOT(adjustBetClicked()));


//a final resize
 stopRaise();
}

BetBox::~BetBox()
{
delete bet5Up;
delete bet10Up;
delete bet5Down;
delete bet10Down;
}

void BetBox::bet5UpClicked()
{ emit betChanged(5); }

void BetBox::bet10UpClicked()
{ emit betChanged(10); }

void BetBox::bet5DownClicked()
{ emit betChanged(-5); }

void BetBox::bet10DownClicked()
{ emit betChanged(-10); }

void BetBox::adjustBetClicked()
{ emit betAdjusted(); }

void BetBox::outClicked()
{ emit out(); }

void BetBox::beginRaise()
{
 const int distance = 3;
 resize(bet10Up->x() + bet10Up->width() + distance, adjustBet->y() + adjustBet->height() + distance);

 bet5Up->setEnabled(false);
 bet10Up->setEnabled(false);
 bet5Down->setEnabled(false);
 bet10Down->setEnabled(false);
}

void BetBox::stopRaise()
{
 const int distance = 3;
 resize(bet10Up->x() + bet10Up->width() + distance, bet10Down->y() + bet10Down->height() + distance);
 
 bet5Up->setEnabled(true);
 bet10Up->setEnabled(true);
 bet5Down->setEnabled(true);
 bet10Down->setEnabled(true);
}

#include "betbox.moc"
