/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// QT includes
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>

// KDE includes
#include <klocale.h>
#include <kapp.h>
#include <kconfig.h>

// own includes
#include "defines.h"
#include "newgamedlg.h"

NewGameDlg::NewGameDlg(QWidget* parent) : QDialog(parent, 0, true)
{
 resize(500, 400);

 const int labelPos = 10;
 const int widgetPos = 300;
 int y = 0;

 QPushButton* ok = new QPushButton(i18n("OK"), this);
 ok->move(this->width() /4 - ok->width() /2, 350);
 ok->setDefault(true);
 connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
 
 QPushButton* cancel = new QPushButton(i18n("Cancel"), this);
 cancel->move(this->width() /2 + this->width() /4 - cancel->width() /2, 350);
 connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));


 KConfig* conf = kapp->config();
 conf->setGroup("NewGameDlg");
 bool showNewGameDlg = conf->readBoolEntry("showNewGameDlgOnStartup", SHOWNEWGAME_DEFAULT);
 bool readConfig = conf->readBoolEntry("readFromConfig", LOADGAME_DEFAULT);
 int playerNr = conf->readNumEntry("players", DEFAULT_PLAYERS);
 int money = conf->readNumEntry("startMoney", START_MONEY);
 

 readFromConfig = new QCheckBox(i18n("Try loading a game"), this);
 readFromConfig->adjustSize();
 readFromConfig->setChecked(readConfig);
 readFromConfig->move(20, 20);
 readFromConfigLabel = new QLabel(i18n("The following values are used if loading from config fails"), this);
 if (!readFromConfig->isChecked())
	 readFromConfigLabel->hide();
 readFromConfigLabel->adjustSize();
 readFromConfigLabel->move(10, 50);
 connect(readFromConfig, SIGNAL(toggled(bool)), this, SLOT(changeReadFromConfig(bool)));

 y = 80;
 QLabel* playersLabel = new QLabel(i18n("How many players do you want?"), this);
 playersLabel->adjustSize();
 playersLabel->move(labelPos, y);
 
 players = new QComboBox(this);
 players->insertItem(QString(i18n("1 player")));
 for (int i = 1; i < MAX_PLAYERS; i++) 
	 players->insertItem(QString(i18n("%1 players")).arg(i+1));
 players->setCurrentItem(playerNr-1);
 players->move(widgetPos, y);

 y += 35;
 QLabel* player1NameLabel = new QLabel(i18n("Your Name"), this);
 player1NameLabel->adjustSize();
 player1NameLabel->move(labelPos, y);

 player1Name = new QLineEdit(this);
 player1Name->move(widgetPos, y);

 y += 35;
 QLabel* moneyLabel = new QLabel(i18n("Start money of the players"), this);
 moneyLabel->adjustSize();
 moneyLabel->move(labelPos, y);

 moneyOfPlayers = new QLineEdit(QString("%1").arg(money), this);
 moneyOfPlayers->move(widgetPos, y);

 y += 40;
 QLabel* computerNamesLabel = new QLabel(i18n("The names of your enemies"), this);
 computerNamesLabel->adjustSize();
 computerNamesLabel->move(labelPos, y);

 computerNames = new QComboBox(true, this);
 computerNames->setInsertionPolicy(QComboBox::AtCurrent);
 computerNames->move(widgetPos, y);

 y += 45;
 QLabel* showLabel = new QLabel(i18n("Show this dialog every time on startup"), this);
 showLabel->adjustSize();
 showLabel->move(labelPos, y);
 
 showDialogOnStartup = new QCheckBox(this);
 showDialogOnStartup->setChecked(showNewGameDlg);
 showDialogOnStartup->adjustSize();
 showDialogOnStartup->move(widgetPos, y); 

 setPlayerNames();
}

NewGameDlg::~NewGameDlg()
{
if (result() == Accepted) {
	KConfig* conf = kapp->config(); 
	conf->setGroup("NewGameDlg"); // defaults for the newGameDlg only
	conf->writeEntry("showNewGameDlgOnStartup", showOnStartup());
	conf->writeEntry("readFromConfig", readFromConfigFile()); // just a default!
	conf->writeEntry("players", getPlayers());
	conf->writeEntry("startMoney", money());
 }
//delete the visible elements:
 delete readFromConfigLabel;
 delete readFromConfig;
 delete players;
 delete moneyOfPlayers;
 delete showDialogOnStartup;
 delete player1Name;
 delete computerNames;

}

void NewGameDlg::setPlayerNames(int no, QString playerName)
{
 if (no < 0) {
	kapp->config()->setGroup("Save");
	player1Name->setText(kapp->config()->readEntry("Name_0", i18n("You")));
	computerNames->clear();
	for (int i = 1; i < MAX_PLAYERS; i++) {
		computerNames->insertItem(kapp->config()->readEntry(QString("Name_%1").arg(i), i18n("Computer %1").arg(i)));
	}
 } else if (no == 0) {
		player1Name->setText(playerName);
 } else {
	if (computerNames->count() > no)
		computerNames->insertItem(playerName, no-1);
	else
		computerNames->changeItem(playerName, no-1);
 }
}

void NewGameDlg::changeReadFromConfig(bool s)
{
 if (s)
	readFromConfigLabel->show();
 else
	readFromConfigLabel->hide();
}

bool NewGameDlg::showOnStartup()
{ return showDialogOnStartup->isChecked(); }

int NewGameDlg::getPlayers()
{ return players->currentItem() + 1; }

bool NewGameDlg::readFromConfigFile()
{ return readFromConfig->isChecked(); }

int NewGameDlg::money()
{
 bool ok = true;
 int m = moneyOfPlayers->text().toInt(&ok);
 if (ok) return m;
 else return START_MONEY;
}

QString NewGameDlg::name(int nr)
{
if (computerNames->currentText() != computerNames->text(computerNames->currentItem()))
	computerNames->changeItem(computerNames->currentText(), computerNames->currentItem());
	
 if (nr == 0)
	return player1Name->text();
 if (nr <= computerNames->count())
	 return computerNames->text(nr-1);
 return i18n("Player");
}

void NewGameDlg::hideReadingFromConfig()
{
readFromConfig->hide();
readFromConfigLabel->hide();
readFromConfig->setChecked(false);
}


#include "newgamedlg.moc"
