/* Yo Emacs, this is -*- C++ -*- */
/*
 *   ksame 0.4 - simple Game
 *   Copyright (C) 1997,1998  Marcus Kreutzberger
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _STONEWIDGET
#define _STONEWIDGET

#include <qpixmap.h>
#include <qwidget.h>
#include "StoneField.h"

struct StoneSlice;

class StoneWidget : public QWidget {
    Q_OBJECT

    int modified;
    //     int marked;            // Anzahl markierter Steine


    int stones_x, stones_y;
    int sizex, sizey;
    int field_width, field_height;

    QList<QPoint> history;
    StoneField stonefield;

    // Bildnummer des Steinmovies
    int slice;

    StoneSlice **map;

public:
    StoneWidget( QWidget *parent=0, int x=10,int y=10);
    ~StoneWidget();

    unsigned int board();
    int score();
    QSize size();
    int colors();
    virtual QSize sizeHint() const;

    bool undoPossible() const;

    void newGame(unsigned int board, int colors);
    void reset();
    void unmark();
    int undo(int count=1);

    // Spielende abfragen
    bool isGameover();

    virtual void readProperties(KConfig *conf);
    virtual void saveProperties(KConfig *conf);

protected:

    void timerEvent( QTimerEvent *e );
    void paintEvent( QPaintEvent *e );
    void mousePressEvent ( QMouseEvent *e);
    void mouseMoveEvent ( QMouseEvent *e);

    // Eigenschaften des SteinBildes
    int stone_width,stone_height; // Pixelgre eines Steines.
    int maxcolors;         // Anzahl verschiedener Steine (Y Richtung)
    int maxslices;         // Anzahl Steine eines Movies  (X Richtung)

signals:
    // Ein neues Spiel beginnt
    void s_newgame();

    void s_colors(int colors);
    void s_board(int board);
    void s_score(int score);
    void s_marked(int m);

    void s_gameover();

    // Der Stein (x,y) wurde angeklickt(entfernt),
     // alle umliegend betroffenen Steine
    // verschwinden automatisch, d.h. kein extra Signal.
    void s_remove(int x,int y);

    void s_sizechanged();
};

#endif





