#ifndef __KGV_VIEW_H
#define __KGV_VIEW_H

#include <kio/job.h>
#include <kparts/browserextension.h>
#include <kparts/factory.h>

class QTimer;

class KInstance;
class KAction;
class KActionCollection;
class KToggleAction;
class KGVMiniWidget;
class KGVBrowserExtension;

class KGVFactory : public KParts::Factory
{
  Q_OBJECT
public:
  KGVFactory();
  virtual ~KGVFactory();

  virtual KParts::Part *createPart( QWidget *parentWidget, const char *widgetName, QObject *parent, const char *name, const char *classname, const QStringList &args );

  static KInstance *instance();

private:
  static KInstance *s_instance;
};


class KSelectAction;

class KGVPart: public KParts::ReadOnlyPart
{
  Q_OBJECT
public:
  KGVPart( bool bBrowserView, QWidget *parentWidget, const char *widgetName, QObject *parent, const char *name );
  virtual ~KGVPart();

  KGVMiniWidget *miniWidget() const { return w; }

  bool openStdin();
  public slots:
    void slotShowMarkList ();
    void slotCancelWatch();

protected slots:
  void slotFancy();
  void slotOrientation (int);
  void slotMedia (int);
  void slotNewPage ();
  void slotWatchFile();
  void slotMarkListShown(bool);

protected:
  KToggleAction *watchaction, *fancyAct, *showmarklist;
  KSelectAction *orientation, *media;
  KActionCollection *statedep;

  // reimplemented from ReadOnlyPart
  virtual bool openFile();
  void enableStateDepActions( bool enable );

  void startWatching();
  void stopWatching();
  void readSettings();
  void writeSettings();

private:
  KGVMiniWidget *w;
  KGVBrowserExtension *m_extension;

  KAction *zoomInAct, *zoomOutAct, *backAct, *forwardAct,
      *startAct, *endAct, *endDocAct, *markAct, *gotoAct;
  
  QTimer *watch;
};

class KGVBrowserExtension : public KParts::BrowserExtension
{
  Q_OBJECT
  friend class KGVPart; // emits our signals
public:
  KGVBrowserExtension( KGVPart *parent );
  virtual ~KGVBrowserExtension() {}

public slots:
  // Automatically detected by konqueror
  void print();

};

#endif


