#include "bitmaplistitem.h"
#include <qpainter.h>

KPBitmapListItem::KPBitmapListItem(QListBox *listBox, const QString &text,
                                   const QColor &c)
    : QListBoxText(listBox, text)
{
    colorBrush = QBrush(c, QBrush::SolidPattern);
}

int KPBitmapListItem::height(const QListBox *listBox)
{
    return(listBox ? listBox->fontMetrics().lineSpacing()+2 >= 20 ?
           listBox->fontMetrics().lineSpacing()+2 : 20 : 0);
}

int KPBitmapListItem::width(const QListBox *listBox)
{
    return(listBox ? listBox->fontMetrics().width(text())+22 : 0);
}

void KPBitmapListItem::paint(QPainter *p)
{
    QFontMetrics fm = p->fontMetrics();
    p->fillRect(2, 2, 16, 16, colorBrush);
    p->drawText(20, fm.ascent()+fm.leading()/2, text());
}
